package de.fzj.unicore.bes.functional;

import java.util.Calendar;
import java.util.GregorianCalendar;

import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentType;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesType;
import org.oasisOpen.docs.wsrf.rl2.TerminationTimeDocument.TerminationTime;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.faults.UnknownActivityIdentifierFault;
import de.fzj.unicore.bes.faults.XmlBeansFault;

/**
 * This test case only tests for the activity statuses
 * */

public class TestMultipleActivities extends BaseActivityTest {

	FactoryClient factory = null;
	
	@Override
	protected void setUp() throws Exception {
		super.setUp();
		setSecurityFlag(true);
		factory = getDefaultFactory();
	}
	
	
	
	
	public void testSingleActivityWithWrongUrl(){
		// this method doesn't parse all urls
		GetActivityStatusesDocument statsDoc = GetActivityStatusesDocument.Factory.newInstance();
		GetActivityStatusesType statsType = statsDoc.addNewGetActivityStatuses();
		
		EndpointReferenceType e=EndpointReferenceType.Factory.newInstance();
		e.addNewAddress().setStringValue("http://someserver.com?res=noresourceid");
		statsType.setActivityIdentifierArray(new EndpointReferenceType[]{e});
	
		try {
			factory.getActivityStatuses(statsDoc);
		} catch (UnknownActivityIdentifierFault ex) {
			ex.printStackTrace();
		}
	}
	

	public void testSingleActivityWithCorrectUrl(){
		
		
		CreateActivityDocument req = CreateActivityDocument.Factory.newInstance();
		ActivityDocumentType activityDocType = req.addNewCreateActivity().addNewActivityDocument();
		activityDocType.setJobDefinition(new DateHPCPJSDL().getJSDL().getJobDefinition());
		TerminationTime tt = TerminationTime.Factory.newInstance();
		Calendar c = new GregorianCalendar();
		c.add(Calendar.MONTH, 2);
		tt.setCalendarValue(c);
		activityDocType.setTerminationTime(tt);
		
		CreateActivityResponseDocument res = null;
		try {
			res = factory.createActivity(req);
		} catch (XmlBeansFault e) {
			e.printStackTrace();
			fail();
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
		
		// this method doesn't parse all urls
		GetActivityStatusesDocument statsDoc = GetActivityStatusesDocument.Factory.newInstance();
		GetActivityStatusesType statsType = statsDoc.addNewGetActivityStatuses();
		statsType.setActivityIdentifierArray(new EndpointReferenceType[]{res.getCreateActivityResponse().getActivityIdentifier()});
	
		try {
			factory.getActivityStatuses(statsDoc);
		} catch (UnknownActivityIdentifierFault e) {
			e.printStackTrace();
			fail();
		}
	}
}
