package de.fzj.unicore.bes.functional;

import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.File;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

import org.apache.commons.io.FileUtils;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentType;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStateEnumeration;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.oasisOpen.docs.wsrf.rl2.TerminationTimeDocument.TerminationTime;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.bes.BES;
import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.functional.DateJSDL;
import de.fzj.unicore.bes.test.EmbeddedServerStartup;

public class TestMultiJobSubmitAndPoll {

//	private static final Logger logger=LogUtil.getLogger(LogUtil.SERVICES, TestMultiThreadedScenarios.class);
	
	protected static FactoryClient factoryClient = null;
	
	@BeforeClass
	public static void startServer() throws Exception {
		FileUtils.deleteQuietly(new File("target","data"));
		EmbeddedServerStartup.serverStartup();
		String BESUrl = EmbeddedServerStartup.getServerUrl()+BES.BF+"?res=default_bes_factory";
		EndpointReferenceType besEPR = EndpointReferenceType.Factory.newInstance();
		besEPR.addNewAddress().setStringValue(BESUrl);
		factoryClient = new FactoryClient(besEPR,EmbeddedServerStartup.getKernel().getClientConfiguration());
	}
	
	@Test
	public void testMultipleActivities() throws Exception {
		
			final CreateActivityDocument reqDoc = CreateActivityDocument.Factory.newInstance();
			CreateActivityType reqType = reqDoc.addNewCreateActivity();
			ActivityDocumentType activityDoc = reqType.addNewActivityDocument();
			TerminationTime tt = TerminationTime.Factory.newInstance();
			Calendar c = new GregorianCalendar();
			c.add(Calendar.MONTH, 2);
			tt.setCalendarValue(c);
			activityDoc.setTerminationTime(tt);
			activityDoc.setJobDefinition(new DateJSDL().getJSDL().getJobDefinition());
			
			long startTime = System.currentTimeMillis();
			
			
			Callable<CreateActivityResponseDocument> creationCallable = new Callable<CreateActivityResponseDocument>() {
				@Override
				public CreateActivityResponseDocument call() throws Exception {
					return factoryClient.createActivity(reqDoc);
				}
			};
			ExecutorService executor = EmbeddedServerStartup.getKernel().getContainerProperties().
					getThreadingServices().getExecutorService();
			
			final int N = 50;
			
			for (int i = 0; i < N; i++) {
				Future<CreateActivityResponseDocument> f1 = executor.submit(creationCallable);
				executor.submit(new TestMultiJobSubmitAndPoll.StatusChecker(f1.get().getCreateActivityResponse().getActivityIdentifier()));
					
			}
			executor.shutdown();
			while (!executor.isTerminated()){}
			
			assertTrue(factoryClient.getTotalNumberOfActivities()==N);
			
			long endTime = System.currentTimeMillis();
			System.out.println("Start Time: "+startTime+ " ms");
			System.out.println("End Time: "+endTime + " ms");
			System.out.println("Total Time: "+ (endTime-startTime) + " ms");
			System.out.println("Average Turnaround Time Per Job: "+(endTime-startTime)/N + " ms");
			
	}
	
	
	
	@AfterClass
	public static void stopServer(){
		EmbeddedServerStartup.getKernel().shutdown();
	}

	private static class StatusChecker implements Callable<String>{
		EndpointReferenceType eprt;
		public StatusChecker(EndpointReferenceType eprt){
			this.eprt = eprt;
		}
			
		@Override
		public String call() throws Exception {

			while (true){
				if(factoryClient.getActivityStatus(eprt).toString().contains("Finished"))
					break;
				else if (factoryClient.getActivityStatus(eprt) == ActivityStateEnumeration.FAILED)
					fail();
				continue;
			}
			return factoryClient.getActivityStatus(eprt).toString();
		}
		
	}
	
}
