package de.fzj.unicore.bes.functional;

import org.apache.log4j.Logger;

import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentType;
import org.ogf.schemas.hpcp.x2007.x01.bp.BasicFilterDocument;
import org.ogf.schemas.hpcp.x2007.x01.bp.BasicFilterType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.faults.InvalidRequestMessageFault;
import de.fzj.unicore.bes.faults.NotAcceptingNewActivitiesFault;
import de.fzj.unicore.bes.faults.UnsupportedFeatureFault;
import de.fzj.unicore.bes.util.ActivityUtils;



/**
 * 
 * test class to verify the implementation of HPCP BasicFilter extension
 * 
 * @author m.memon
 *
 */
public class TestBasicActivityFilter extends BaseActivityTest {

	private static final Logger logger = Logger
			.getLogger(TestBasicActivityFilter.class.getName());
	private FactoryClient client;

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		setSecurityFlag(true);
		client = getDefaultFactory();
	}

	public void testGetFactoryAttributesDoc() throws Exception {
		CreateActivityDocument caDoc = CreateActivityDocument.Factory
				.newInstance();
		CreateActivityType caType = caDoc.addNewCreateActivity();
		caType.addNewActivityDocument().setJobDefinition(
				new DateHPCPJSDL().getJSDL().getJobDefinition());

		for (int i = 0; i < 10; i++) {
			try {
				logger.info("Creating Activity: "+(i+1));
				client.createActivity(caDoc);
			} catch (NotAcceptingNewActivitiesFault e) {
				e.printStackTrace();
			} catch (InvalidRequestMessageFault e) {
				e.printStackTrace();
			} catch (UnsupportedFeatureFault e) {
				e.printStackTrace();
			}
		}

		GetFactoryAttributesDocumentDocument1 gfDoc = GetFactoryAttributesDocumentDocument1.Factory.newInstance();
		
		GetFactoryAttributesDocumentType gfType =  gfDoc.addNewGetFactoryAttributesDocument();
		String result = client.getFactoryAttributesDocument(gfDoc).toString();
		assertTrue(result.contains("ActivityReference") && result.contains("http://schemas.ogf.org/hpcp/2007/01/bp/BasicFilter"));
		
		gfType.set(ActivityUtils.filterActivityAndResources());
		assertTrue(getNumberOfActivities(client, gfDoc)>0);
		
		
		gfType.set(ActivityUtils.filterOnlyActivityBeans());
		assertTrue(getNumberOfActivities(client, gfDoc)>0);
		
		
		gfType.set(ActivityUtils.filterOnlyResourceBeans());
		assertFalse(getNumberOfActivities(client, gfDoc)>0);
		
		gfType.set(ActivityUtils.filterNoneBeans());
		assertFalse(getNumberOfActivities(client, gfDoc)>0);
		
		
		result = client.getResourcePropertyDocument();
		assertTrue(result.contains("ActivityReference"));

	}
	
	
	private int getNumberOfActivities(FactoryClient c, GetFactoryAttributesDocumentDocument1 g)throws Exception{
		return c.getFactoryAttributesDocument(g).getGetFactoryAttributesDocumentResponse().getFactoryResourceAttributesDocument().getActivityReferenceArray().length;
	}
	
	
	private XmlObject filterActivityAndResources() {
		BasicFilterDocument bfDoc = BasicFilterDocument.Factory.newInstance();
		BasicFilterType bfType = bfDoc.addNewBasicFilter();
		bfType.setActivityReferences(true);
		bfType.setContainedResources(true);
		return bfDoc;
	}

	private XmlObject filterOnlyActivityBeans() {
		BasicFilterDocument bfDoc = BasicFilterDocument.Factory.newInstance();
		BasicFilterType bfType = bfDoc.addNewBasicFilter();
		bfType.setActivityReferences(true);
		bfType.setContainedResources(false);
		return bfDoc;
	}

	private XmlObject filterOnlyResourceBeans() {
		BasicFilterDocument bfDoc = BasicFilterDocument.Factory.newInstance();
		BasicFilterType bfType = bfDoc.addNewBasicFilter();
		bfType.setActivityReferences(false);
		bfType.setContainedResources(true);
		return bfDoc;
	}

	private XmlObject filterNoneBeans() {
		BasicFilterDocument bfDoc = BasicFilterDocument.Factory.newInstance();
		BasicFilterType bfType = bfDoc.addNewBasicFilter();
		bfType.setActivityReferences(false);
		bfType.setContainedResources(false);
		return bfDoc;
	}

	public void testgetFactoryRequest() {
		GetFactoryAttributesDocumentDocument1 gfDoc = GetFactoryAttributesDocumentDocument1.Factory
				.newInstance();
		
		gfDoc.addNewGetFactoryAttributesDocument().set(filterActivityAndResources());

		logger.debug(gfDoc.toString());

		XmlCursor cursor = gfDoc.newCursor();

		Node node = gfDoc.getGetFactoryAttributesDocument().getDomNode();

		if (node.getFirstChild() != null) {
			NodeList nList = node.getFirstChild().getChildNodes();

			for (int i = 0; i < nList.getLength(); i++) {
				Node n = nList.item(i);
				if(n.getNodeName().equals("ActivityReferences"))
					assertTrue(n.getFirstChild().getNodeValue().equals("true"));
				else if(n.getNodeName().equals("ContainedResources"))
					assertTrue(n.getFirstChild().getNodeValue().equals("true"));	
			}
		}
		
		
	}

}
