package de.fzj.unicore.bes.functional;

import org.apache.log4j.Logger;
import org.codehaus.xfire.fault.XFireFault;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besManagement.StopAcceptingNewActivitiesDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import de.fzj.unicore.bes.BES;
import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.client.ManagementClient;
import de.fzj.unicore.bes.faults.InvalidRequestMessageFault;
import de.fzj.unicore.bes.faults.NotAcceptingNewActivitiesFault;
import de.fzj.unicore.bes.faults.UnsupportedFeatureFault;


public class TestBESManagement extends BaseActivityTest {
	private static Logger logger = Logger.getLogger(TestBESManagement.class.getName());

	@Override
	protected void setUp() throws Exception {
		// TODO Auto-generated method stub
		super.setUp();
		setSecurityFlag(true);
		
	}

	public void testManagingActivities() {
		
		JobDefinitionDocument jobDoc = new DateJSDL().getJSDL();

		ActivityDocumentDocument1 actDoc = ActivityDocumentDocument1.Factory
				.newInstance();

		actDoc.addNewActivityDocument().setJobDefinition(
				jobDoc.getJobDefinition());

		CreateActivityDocument caDoc = CreateActivityDocument.Factory
				.newInstance();
		caDoc.addNewCreateActivity().setActivityDocument(
				actDoc.getActivityDocument());

		FactoryClient fc = null;
		
		ManagementClient client = null;
		try {

			fc = getDefaultFactory();

			CreateActivityResponseDocument cresDoc = fc.createActivity(caDoc);

			Thread.sleep(2000);

			client = new ManagementClient(serverUrl + BES.BM, makeSecurityProperties());
			
			
		} catch (Exception e) {
			fail();
			e.printStackTrace();
		}
		// StartAcceptingNewActivitiesDocument startDoc =
		// StartAcceptingNewActivitiesDocument.Factory.newInstance();
		// startDoc.addNewStartAcceptingNewActivities();
		// mgtObj.StartAcceptingNewActivities(startDoc);

		// when testing start activities uncomment the try catch block of create
		// activity below
		StopAcceptingNewActivitiesDocument stopDoc = StopAcceptingNewActivitiesDocument.Factory.newInstance();
				
		try {
			stopDoc.addNewStopAcceptingNewActivities();
			logger.info(client.stopAcceptingNewActivities().toString());
		} catch (XFireFault e1) {
			e1.printStackTrace();
			fail();
		}
		
		
			// not sending new job
		try {
			fc.createActivity(caDoc);
		} catch (NotAcceptingNewActivitiesFault e) {
			e.printStackTrace();
			assertTrue("BES is not accepting new activities", true);
		} catch (InvalidRequestMessageFault e) {
			e.printStackTrace();
		} catch (UnsupportedFeatureFault e) {
			e.printStackTrace();
		}
		catch (Exception e){
			fail();
		}

	}

	
}
