package de.fzj.unicore.bes.functional;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

import org.apache.log4j.Logger;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentType;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentsDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentsResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentsType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesType;
import org.oasisOpen.docs.wsrf.rl2.TerminationTimeDocument.TerminationTime;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.bes.client.ActivityClient;
import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.faults.UnknownActivityIdentifierFault;
import de.fzj.unicore.bes.util.BESUtils;

public class TestBESFactory extends BaseActivityTest {
	private static Logger logger = Logger.getLogger(TestBESFactory.class.getName());
	
	
	FactoryClient client;

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		setSecurityFlag(true);
		client = getDefaultFactory();
	}

	public void testCreateActivity() {

		CreateActivityDocument req = CreateActivityDocument.Factory
				.newInstance();
		ActivityDocumentType activityDocType = req.addNewCreateActivity()
				.addNewActivityDocument();
		activityDocType.setJobDefinition(new DateHPCPJSDL().getJSDL()
				.getJobDefinition());
		TerminationTime tt = TerminationTime.Factory.newInstance();
		Calendar c = new GregorianCalendar();
		c.add(Calendar.MONTH, 2);
		tt.setCalendarValue(c);
		activityDocType.setTerminationTime(tt);
		try {
			CreateActivityResponseDocument cresDoc = client.createActivity(req);

			System.out.println(cresDoc.getCreateActivityResponse().getActivityIdentifier());

			ActivityClient activityClient = getActivityClient(cresDoc.getCreateActivityResponse().getActivityIdentifier());

			System.out.println("BA ResourceID: "+ activityClient.getEPR().getAddress().getStringValue());

			// /////////////////////////////////////////
			// checking output//////////////////////////
			// ////////////////////////////////////////

			// /////////////////////////////////////////////////////////////////////////

			// /////////////////////////////////////////////////////////////////////////
			logger.info("In test case:   ");
			String stEpr = cresDoc.getCreateActivityResponse().getActivityIdentifier().getAddress().getStringValue();
			logger.info("The epr of Activity: " + stEpr);
			assertTrue(stEpr.toLowerCase().contains("besactivity"));

			// getJobOutcome(activity);
		} catch (Exception e) {
			logger.error(e);
			fail();
		}

	}

	/**
	 * Tests BESFactory getAttributesDocument method
	 * 
	 */

	public void testGetAttributesDocument() {

		try {
			GetFactoryAttributesDocumentDocument1 req = GetFactoryAttributesDocumentDocument1.Factory.newInstance();
			req.addNewGetFactoryAttributesDocument();
			Thread.sleep(3000);
			GetFactoryAttributesDocumentResponseDocument res = client.getFactoryAttributesDocument(req);
			System.out.println(res.toString());
			logger.info("Attributes Document:   " + res.toString());

		} catch (Exception e) {
			logger.info(e.getMessage());
			fail();
		}
	}

	/**
	 * TestGetActivityStatuses method tests the statuses of EPRs that user
	 * provides. This method takes some sample EPRs and calling BESFactory's
	 * getActivityStatuses method. The Webservice method should return EPRs,
	 * supposedly if they are not alive and/or not authorized by the user then
	 * it will throw SOAP fault.
	 * 
	 * @throws Exception
	 * 
	 */

	/**
	 * @throws Exception
	 */
	public void testGetActivityStatuses() throws Exception {

		GetActivityStatusesDocument gStatsDoc = GetActivityStatusesDocument.Factory.newInstance();

		GetActivityStatusesType gStatsType = gStatsDoc.addNewGetActivityStatuses();

		List<EndpointReferenceType> eprs = createActivityInstances(	new DateJSDL(), 10);
		
		// setting Activity Instances
		gStatsType.setActivityIdentifierArray(eprs
				.toArray(new EndpointReferenceType[eprs.size()]));

		// waiting for output to be written on the filespace

		// calling getActivityStatuses
		GetActivityStatusesResponseDocument gStatsResDoc = client.getActivityStatuses(gStatsDoc);
				
		System.out.println("GetActivityStatusesResponseDocument:  " + gStatsResDoc.toString());

		assertTrue(gStatsResDoc.toString().contains("activity_resourceid_7"));

	}

	/**
	 * TestGetActivityDocuments method tests the statuses of EPRs that user
	 * provides. This method takes some sample EPRs and calling BESFactory's
	 * getActivityDocuments method. The Webservice method should return EPRs,
	 * supposedly if they are not alive and/or not authorized by the user then
	 * it will throw SOAP fault.
	 * 
	 * @throws Exception
	 * 
	 */

	/**
	 * @throws Exception
	 */
	public void testGetActivityDocuments() throws Exception {

		GetActivityDocumentsDocument reqDoc = GetActivityDocumentsDocument.Factory
				.newInstance();

		GetActivityDocumentsType reqType = reqDoc.addNewGetActivityDocuments();

		List<EndpointReferenceType> eprs = createActivityInstances(new DateJSDL(), 10);
		
		
		reqType.setActivityIdentifierArray(eprs.toArray(new EndpointReferenceType[eprs.size()]));

		Thread.sleep(1000);
		
		// calling getActivityStatuses
		GetActivityDocumentsResponseDocument gResDoc = getDefaultFactory().getActivityDocuments(reqDoc);
		
		System.out.println(gResDoc);
		
		assertTrue(gResDoc.toString().contains("activity_resourceid_7"));
	}

	/**
	 * 
	 * Helper method to create real and dummy activities that is used by
	 * GetActivityStatuses and TerminateActivities method.
	 * 
	 * @param BESFactory
	 *            object
	 * @return array of endpoint references
	 * 
	 */

	private List<EndpointReferenceType> createActivityInstances(
			JSDLActivity jsdl, int numberOfActivties) {

		if (numberOfActivties < 2)
			throw new RuntimeException(
					"Number of Activities must be greater than 2");

		ActivityDocumentDocument1 actDoc = ActivityDocumentDocument1.Factory
				.newInstance();
		
		try {
			actDoc.addNewActivityDocument().setJobDefinition(BESUtils.getJSDLFromFile("src/test/resources/jsdl/netstat.xml").getJobDefinition());
		} catch (Exception e1) {
			e1.printStackTrace();
			fail("Couldn't find jsdl file.");
		}

		CreateActivityDocument caDoc = CreateActivityDocument.Factory
				.newInstance();

		caDoc.addNewCreateActivity().setActivityDocument(actDoc.getActivityDocument());

		CreateActivityResponseDocument cresDoc = null;
		EndpointReferenceType[] eTypeArry = new EndpointReferenceType[numberOfActivties];

		List<EndpointReferenceType> eprList = new ArrayList<EndpointReferenceType>();

		

		int eprArrySize = eTypeArry.length;
		try {
			// putting instances which are really created by BESFactory
			for (int i = 0; i < eprArrySize / 2; i++) {
				cresDoc = client.createActivity(caDoc);
				eprList.add(cresDoc.getCreateActivityResponse()
						.getActivityIdentifier());

			}
			
			

			
			
			// creating dummy BESActivity eprs
			for (int j = eprArrySize / 2; j < eprArrySize; j++) {
				EndpointReferenceType e=EndpointReferenceType.Factory.newInstance();
				e.addNewAddress().setStringValue(serverUrl + "BESActivity?res="+
						"activity_resourceid_" + j);

			}

		} catch (Exception e) {
			e.printStackTrace();
		}
		
//		eprList.add(BESUtils.makeSimpleEPR(serverUrl + "BESActivity","f5752cd2-b75f-497d-bb9e-97058cd987b0"));
		return eprList;
	}

	/**
	 * In this test method one cannot figure out the termination of existing
	 * running job, because it finishes abruptly. and terminate action fired
	 * after the job is finished.
	 * 
	 */
	public void testTerminateActivities() {

		TerminateActivitiesDocument tActDoc = TerminateActivitiesDocument.Factory.newInstance();
		TerminateActivitiesType tActType = tActDoc.addNewTerminateActivities();

		List<EndpointReferenceType> eprs = createActivityInstances(new CatJSDL(getSecurityFlag()), 5);
		// List<EndpointReferenceType> eprs = createActivityInstances(new
		// DateJSDL(), 8);

		// eprs.toArray(new EndpointReferenceType[eprs.size()]);

		tActType.setActivityIdentifierArray(eprs.toArray(new EndpointReferenceType[eprs.size()]));

		// calling getActivityStatuses
		TerminateActivitiesResponseDocument tActResDoc = null;
		try {
			tActResDoc = client.terminateActivities(tActDoc);
		} catch (UnknownActivityIdentifierFault e) {
			e.printStackTrace();
			fail();
		}
		System.out.println(tActResDoc);
	}

}
