package de.fzj.unicore.bes.functional;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDescriptionType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobIdentificationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.OperatingSystemTypeEnumeration;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ProcessorArchitectureEnumeration;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;
import org.ggf.schemas.jsdl.x2006.x07.jsdlHpcpa.HPCProfileApplicationDocument;
import org.ggf.schemas.jsdl.x2006.x07.jsdlHpcpa.HPCProfileApplicationType;



public class DateHPCPJSDL implements JSDLActivity{
	
	public JobDefinitionDocument getJSDL() {
		HPCProfileApplicationDocument hpcDoc = HPCProfileApplicationDocument.Factory.newInstance();
		HPCProfileApplicationType hpcType = hpcDoc.addNewHPCProfileApplication();
		hpcType.addNewExecutable().setStringValue("/bin/date");
		
		
		
		JobDefinitionDocument jdd = JobDefinitionDocument.Factory.newInstance();
		JobDescriptionType jdt = jdd.addNewJobDefinition().addNewJobDescription();
		ApplicationType app = jdt.addNewApplication();
		app.set(hpcDoc);
		ResourcesType resType = jdt.addNewResources();
		resType.addNewOperatingSystem().addNewOperatingSystemType().setOperatingSystemName(OperatingSystemTypeEnumeration.BSDUNIX);
		resType.addNewTotalCPUCount().addNewExact().setStringValue("1");
		resType.addNewCPUArchitecture().setCPUArchitectureName(ProcessorArchitectureEnumeration.X_86_32);
		resType.setExclusiveExecution(true);
	
		JobIdentificationType jid = jdt.addNewJobIdentification();
		jid.setJobName("date_local");
		jid.setJobProjectArray(new String[]{"date_local_project"});
		return jdd;
	}

	public static void main(String[] args) {
		System.out.println(new DateHPCPJSDL().getJSDL());
	}
}
