package de.fzj.unicore.bes.functional;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;

import de.fzj.unicore.bes.client.ActivityClient;
import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.faults.InvalidRequestMessageFault;
import de.fzj.unicore.bes.faults.NotAcceptingNewActivitiesFault;
import de.fzj.unicore.bes.faults.UnsupportedFeatureFault;
import de.fzj.unicore.uas.client.RByteIOClient;
import de.fzj.unicore.uas.client.StorageClient;

/**
 * This class tests CAT application with explicit data staging-in/out using 
 * SMS's import and export functions.  
 * @author m.memon
 * */
public class CatUASMode extends BaseActivityTest{
	Logger logger = Logger.getLogger(CatUASMode.class);
	
	@Override
	protected void setUp() throws Exception {
		super.setUp();
		setSecurityFlag(true);
	}
	
	/**
	 * Create activity test method
	 * @throws Exception 
	 */
	public void testCreateActivity(){
		FactoryClient client;
		try {
			client = getDefaultFactory();
		} catch (Exception e1) {
			e1.printStackTrace();
			fail(e1.toString());
			return; //dummy
		}
		CreateActivityDocument req = CreateActivityDocument.Factory.newInstance();
		req.addNewCreateActivity().addNewActivityDocument().setJobDefinition(new CatJSDL(getSecurityFlag()).getJSDLWithoutDataStaging().getJobDefinition());
		
		CreateActivityResponseDocument res = null;
		try {
			res = client.createActivity(req);
		} catch (NotAcceptingNewActivitiesFault e) {
			e.printStackTrace();
			fail();
		} catch (InvalidRequestMessageFault e) {
			e.printStackTrace();
			fail();
		} catch (UnsupportedFeatureFault e) {
			e.printStackTrace();
			fail();

		}
		
		ActivityClient activityClient;
		try
		{
			activityClient = getActivityClient(
					res.getCreateActivityResponse().getActivityIdentifier());
		} catch (Exception e1)
		{
			e1.printStackTrace();
			fail(e1.toString());
			return; //dummy
		} 
		
		
		
		StorageClient sClient = null;
		try {
			
			
			sClient = activityClient.getUspaceClient();
			sClient.getImport("/infile").write("this is a test string".getBytes());
			activityClient.waitUntilReady(180*1000);
			activityClient.start();
			Thread.sleep(500);
			
			
		} catch (Exception e) {
				e.printStackTrace();
				fail();
		}
	
		
		RByteIOClient fileClient = null;
		
		
		
		
		try {
			fileClient = sClient.getExport("/stdout");
		} catch (IOException e) {
			e.printStackTrace();
			fail();
		}
		ByteArrayOutputStream bos=new ByteArrayOutputStream();
		
		try {
			fileClient.readAllData(bos);
			
		} catch (IOException e) {
			e.printStackTrace();
			fail();
		}
		
		
		
		String output = new String(bos.toByteArray());
		
		assertTrue(output.contains("this is a test string"));
	}
	
	
	
	
	
	
}
