package de.fzj.unicore.bes.functional;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.CreationFlagEnumeration;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.DataStagingType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.SourceTargetType;

public class CatJSDL implements JSDLActivity{
	
	
	protected String protocol;
	protected boolean sec = false;
	
	public CatJSDL() {
		protocol = "http";
	}
	
	public CatJSDL(boolean s) {
		this();
		sec = s;
		if(sec)	protocol += "s";
	}
	
	public JobDefinitionDocument getJSDL() {
		JobDefinitionDocument jdd = JobDefinitionDocument.Factory.newInstance();
		ApplicationType app = jdd.addNewJobDefinition().addNewJobDescription().addNewApplication();
		app.setApplicationName("Cat");
		app.setApplicationVersion("1.0");
		DataStagingType s = jdd.getJobDefinition().getJobDescription().addNewDataStaging();
		s.setFileName("/infile");
		s.setCreationFlag(CreationFlagEnumeration.OVERWRITE);
		SourceTargetType stt = SourceTargetType.Factory.newInstance();
		
		String uri = "RBYTEIO:"+protocol+"://localhost:7777/services/StorageManagement?res=default_storage#test.txt";
//		String uri = "RBYTEIO:http://localhost:7774/services/StorageManagement?res=default_storage#test_remote.txt";
		stt.setURI(uri);
		s.setSource(stt);
		
		DataStagingType t = jdd.getJobDefinition().getJobDescription().addNewDataStaging();
		t.setFileName("stdout");
		t.setCreationFlag(CreationFlagEnumeration.OVERWRITE);
		SourceTargetType sttt = SourceTargetType.Factory.newInstance();
		String turi = "RBYTEIO:https://localhost:7777/services/StorageManagement?res=default_storage#out1.txt";
		sttt.setURI(turi);
		t.setTarget(sttt);

		return jdd;
	
	}
	
	
	public JobDefinitionDocument getJSDLWithoutDataStaging() {
		JobDefinitionDocument jdd = JobDefinitionDocument.Factory.newInstance();
		ApplicationType app = jdd.addNewJobDefinition().addNewJobDescription().addNewApplication();
		app.setApplicationName("Cat");
		app.setApplicationVersion("1.0");
		return jdd;
	
	}

	
	
	
	

}
