package de.fzj.unicore.bes.functional;

import java.io.ByteArrayOutputStream;
import org.apache.log4j.Logger;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import de.fzj.unicore.bes.client.ActivityClient;
import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.faults.InvalidRequestMessageFault;
import de.fzj.unicore.bes.faults.NotAcceptingNewActivitiesFault;
import de.fzj.unicore.bes.faults.UnsupportedFeatureFault;
import de.fzj.unicore.uas.client.RByteIOClient;
import de.fzj.unicore.uas.client.StorageClient;


/**
 * Test case testing cat job with output. 
 * @author m.memon
 * */

public class CatActivityRByteIO extends BaseActivityTest{

	Logger logger = Logger.getLogger(CatActivityRByteIO.class);
	
	@Override
	protected void setUp() throws Exception {
		super.setUp();
		setSecurityFlag(true);
		
	}
	
	/**
	 * Create activity test method
	 * @throws Exception 
	 */
	public void testCreateActivity(){
		FactoryClient client;
		try {
			client = getDefaultFactory();
		} catch (Exception e1) {
			e1.printStackTrace();
			fail();
			return;
		}
		CreateActivityDocument req = CreateActivityDocument.Factory.newInstance();
		req.addNewCreateActivity().addNewActivityDocument().setJobDefinition(new CatJSDL(getSecurityFlag()).getJSDL().getJobDefinition());
		
		CreateActivityResponseDocument res = null;
		try {
			res = client.createActivity(req);
			System.out.println(res);
		} catch (NotAcceptingNewActivitiesFault e) {
			e.printStackTrace();
			fail();
		} catch (InvalidRequestMessageFault e) {
			e.printStackTrace();
			fail();
		} catch (UnsupportedFeatureFault e) {
			e.printStackTrace();
			fail();

		}
		
		ActivityClient activityClient;
		try {
			activityClient = getActivityClient(res.getCreateActivityResponse().getActivityIdentifier());
		} catch (Exception e1) {
			e1.printStackTrace();
			fail();
			return;
		} 
		
		StorageClient sClient = null;
		try {
			sClient = activityClient.getUspaceClient();
			activityClient.waitUntilDone(180);
		} catch (Exception e) {
				e.printStackTrace();
				fail();
		}
		RByteIOClient fileClient = null;
		
		try {
			fileClient = sClient.getExport("/stdout");
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		} 
		ByteArrayOutputStream bos=new ByteArrayOutputStream();
		try {
			fileClient.readAllData(bos);
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		} 
		
		String output = new String(bos.toByteArray());
		System.out.println(output);
//		assertTrue(output.toLowerCase().contains("this is bes test"));
		
	}
	
	
}
