package de.fzj.unicore.bes.functional;


import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.apache.log4j.Logger;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import org.unigrids.services.atomic.types.ProtocolType;
import org.unigrids.x2006.x04.services.sms.ExportFileDocument;
import org.unigrids.x2006.x04.services.sms.ExportFileResponseDocument;
import org.unigrids.x2006.x04.services.sms.ImportFileDocument;
import org.unigrids.x2006.x04.services.sms.ImportFileResponseDocument;

import de.fzj.unicore.bes.client.ActivityClient;
import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.faults.InvalidRequestMessageFault;
import de.fzj.unicore.bes.faults.NotAcceptingNewActivitiesFault;
import de.fzj.unicore.bes.faults.UnsupportedFeatureFault;
import de.fzj.unicore.uas.client.RByteIOClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.HttpFileTransferClient;
import de.fzj.unicore.wsrflite.utils.StopWatch;



/**
 * 
 * test class for probing cat activity. It also checks the file transfer mechanisms.
 * 
 * @author m.memon
 *
 */
public class CatActivityHTTP extends BaseActivityTest  {

	Logger logger = Logger.getLogger(CatActivityHTTP.class);
		
	@Override
	protected void setUp() throws Exception {
		super.setUp();
		setSecurityFlag(true);
		
	}
	
	/**
	 * Create activity test method
	 * @throws Exception 
	 * @throws Exception 
	 */
	public void testCreateActivity() throws Exception{
		FactoryClient client = getDefaultFactory();
		CreateActivityDocument req = CreateActivityDocument.Factory.newInstance();
		req.addNewCreateActivity().addNewActivityDocument().setJobDefinition(new DateJSDL().getJSDL().getJobDefinition());
		
		CreateActivityResponseDocument resC = null;
		try {
			resC = client.createActivity(req);
		} catch (NotAcceptingNewActivitiesFault e) {
			e.printStackTrace();
			fail();
		} catch (InvalidRequestMessageFault e) {
			e.printStackTrace();
			fail();
		} catch (UnsupportedFeatureFault e) {
			e.printStackTrace();
			fail();

		}
		
		ActivityClient activityClient = getActivityClient(resC.getCreateActivityResponse().getActivityIdentifier()); 
		StorageClient sClient = null;
		try {
			sClient = activityClient.getUspaceClient();
			System.out.println(activityClient.getEPR());
			activityClient.waitUntilDone(180*1000);
			
		} catch (Exception e) {
				e.printStackTrace();
				fail();
		}
		
		RByteIOClient importClient=sClient.getImport("bigfile");
		int size=128000;
		int loops=10;
		byte[] data=new byte[size];
		Random r=new Random();
		
		StopWatch sw=new StopWatch();
		sw.start("Start import of "+size*loops/(1024*1024)+ " MBytes");
		System.out.println("Start import of "+size*loops/(1024*1024)+ " MBytes");
		for (int i = 0; i < loops; i++) {
			r.nextBytes(data);
			importClient.append(data);
		}
		sw.stop("End.");
		long time=sw.getCurrentTotal();
		System.out.println("End of data import, time="+time/1000+ " sec");
		System.out.println("Rate="+(size*loops)/time+ " kB/sec.");
		
		//data export
		RByteIOClient exportClient=sClient.getExport("bigfile");
		
		sw.start("Start export of "+size*loops/(1024*1024)+ " MBytes");
		System.out.println("Start export of "+size*loops/(1024*1024)+ " MBytes");
		exportClient.readAllData(new OutputStream(){
			public void write(int b) throws IOException {
			}
		});

		sw.stop("End.");
	    time=sw.getCurrentTotal();
		System.out.println("End of rbyteio data export, time="+time/1000+ " sec");
		System.out.println("Rate="+(size*loops)/time+ " kB/sec.");
		
		
		sw.start("Start Baseline/HTTP.");
		ExportFileDocument in=ExportFileDocument.Factory.newInstance();
		in.addNewExportFile().setProtocol(ProtocolType.BFT);
		in.getExportFile().setSource("/bigfile");
		ExportFileResponseDocument res=sClient.ExportFile(in);
		
		HttpFileTransferClient ft=new HttpFileTransferClient(res.getExportFileResponse().getExportEPR().getAddress().getStringValue(),res.getExportFileResponse().getExportEPR(),sp);
		
		
		ft.readAllData(new OutputStream(){
			public void write(int b) throws IOException {
			}
		});
		
		
		sw.stop("End HTTP.");
	    time=sw.getCurrentTotal();
		System.out.println("End of http data export, time="+time/1000+ " sec");
		System.out.println("Rate="+(size*loops)/time+ " kB/sec.");
		
		//test putting a file
		
		String testString="this is a test";
		ByteArrayInputStream bis=new ByteArrayInputStream(testString.getBytes());
		ImportFileDocument imp=ImportFileDocument.Factory.newInstance();
		imp.addNewImportFile().setProtocol(ProtocolType.BFT);
		imp.getImportFile().setDestination("/testfile");
		
		ImportFileResponseDocument res2=sClient.ImportFile(imp);
		HttpFileTransferClient http2=new HttpFileTransferClient(res2.getImportFileResponse().getImportEPR().getAddress().getStringValue(),res2.getImportFileResponse().getImportEPR(),sp);
		http2.writeAllData(bis);
		
		//and read it again
		ByteArrayOutputStream os=new ByteArrayOutputStream();
		sClient.getExport("/testfile").readAllData(os);
		System.out.println(os.toString());
		assertTrue(os.toString().equals(testString));
	}
	
	
	



	
}
