package de.fzj.unicore.bes.functional;

import java.io.DataOutputStream;
import java.io.FileOutputStream;

import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentType;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentDocument1;
import org.unigrids.x2006.x04.services.tss.SubmitDocument;
import org.unigrids.x2006.x04.services.tss.SubmitResponseDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.bes.BES;
import de.fzj.unicore.bes.BESActivity;
import de.fzj.unicore.bes.client.ActivityClient;
import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.util.BESUtils;
import de.fzj.unicore.uas.JobManagement;
import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.uas.client.TSFClient;
import de.fzj.unicore.uas.client.TSSClient;


public class BenchmarkActivity extends BaseActivityTest {

	public static final String BASEURL = "https://zam935:7777/services";

	/* 
	 * The sequence number of jobs to be submitted serially
	 * */
	
    private final int loop[] = { 1 , 10, 50, 100, 250, 500, 750};

	
	public static void main(String[] args) {
		try {

			/*
			 * Start benchmarking for unicore ogsa-bes
			 * */
			new BenchmarkActivity().besJobSubmit();
			
			/*
			 * Start benchmarking for unicore atomic services 
			 * */
			
			new BenchmarkActivity().uasJobSubmit();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	
	
	public void besJobSubmit() throws Exception {
		String besurl = BASEURL+"/"+BES.BF+"?res=default_bes_factory";
		EndpointReferenceType feprt = EndpointReferenceType.Factory.newInstance();
		feprt.addNewAddress().setStringValue(besurl);
		FactoryClient fClient = new FactoryClient(besurl, feprt, makeSecurityProperties());
		
		GetFactoryAttributesDocumentDocument1 doc = GetFactoryAttributesDocumentDocument1.Factory.newInstance();
		doc.addNewGetFactoryAttributesDocument();

		CreateActivityDocument req = CreateActivityDocument.Factory.newInstance();
		
		CreateActivityResponseDocument cres = null;
		
		
		
		ActivityDocumentType activityDocType = req.addNewCreateActivity().addNewActivityDocument();
		activityDocType.setJobDefinition(BESUtils.getJSDLFromFile("src/test/resources/jsdl/jsdlinstance.xml").getJobDefinition());
		
		DataOutputStream out;
		try {
			
			/*
			 * The outputs of benchmarking for unicore-ogsabes will be stored in the following address:
			 * 
			 * */
			out = new DataOutputStream(new FileOutputStream("/tmp/unicore-bes"));
			int index = 0;

			int l = 0;
			String state = null;
			for (; index < loop.length; index++) {

				l = loop[index];
				long startTime = System.currentTimeMillis();

				out.writeBytes("# START RECORD\n");
				out.writeBytes("# START HEADER\n");
				out.writeBytes("# Script start time: " + startTime + "\n");
				out.writeBytes("# Middleware:unicore-bes\n");
				out.writeBytes("# Number of jobs : " + l);
				out.writeBytes("\n# Jobtype : 0 \n");

				java.net.InetAddress localMachine = java.net.InetAddress
						.getLocalHost();
				out.writeBytes("# Submitted from: "
						+ localMachine.getHostAddress() + "\n");

				out
						.writeBytes("# Output columns: submit_time , data_fetched_time\n");
				out.writeBytes("# END_HEADER\n");

				for (int i = 0; i < l; i++) {

					startTime = System.currentTimeMillis();
					cres = fClient.createActivity(req);
					out.writeBytes(startTime + ",");
					
					
					ActivityClient ac = new ActivityClient(BASEURL+"/"+BES.BA,cres.getCreateActivityResponse().getActivityIdentifier(), makeSecurityProperties());
					
					
					boolean statFlag = false;
					
					while (!statFlag) {
						 
						/*
						 * The calculation steps for producing the results
						 * 
						 * */
						state = ac.getResourceProperty(BESActivity.RPStatus);
						
						if (state.contains("Finished")) {
							statFlag = true;
							long statTime = System.currentTimeMillis();
							out.writeBytes(Long.toString(statTime));
							out.writeBytes("\n");
						}
						if (state.contains("Failed")) {
							statFlag = true;
							System.out.println(state);
							i = i - 1;

						}

					}
				}
				out.writeBytes("# END_RECORD \n");
				out.writeBytes("\n");

			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void uasJobSubmit() throws Exception {
			

		EndpointReferenceType tsfepr = EndpointReferenceType.Factory
				.newInstance();
		tsfepr.addNewAddress().setStringValue(
				BASEURL + "/" + UAS.TSF + "?res=default_target_system_factory");
		
			
		TSFClient tsf = new TSFClient(BASEURL + "/" + UAS.TSF, tsfepr,
				makeSecurityProperties());

		
		/*
		 * The outputs of benchmarking for unicore-atomic services  will be stored in the following address:
		 * 
		 * */
		
		DataOutputStream out = new DataOutputStream(new FileOutputStream(
				"/tmp/unicore-uas"));
		TSSClient tss = tsf.createTSS();
		
		int index = 0;

		int l = 0;

		for (; index < loop.length; index++) {

			l = loop[index];
			long startTime = System.currentTimeMillis();

			out.writeBytes("# START RECORD\n");
			out.writeBytes("# START HEADER\n");
			out.writeBytes("# Script start time: " + startTime + "\n");
			out.writeBytes("# Middleware:unicore-uas\n");
			out.writeBytes("# Number of jobs : " + l);
			out.writeBytes("\n# Jobtype : 0 \n");

			java.net.InetAddress localMachine = java.net.InetAddress
					.getLocalHost();
			out.writeBytes("# Submitted from: " + localMachine.getHostAddress()
					+ "\n");

			out.writeBytes("# Output columns: submit_time , data_fetched_time\n");
			out.writeBytes("# END_HEADER\n");

			for (int i = 0; i < l; i++) {

				startTime = System.currentTimeMillis();
				JobClient job = submitJob(tss);
				job.waitUntilReady(3);
				job.start();
				
				out.writeBytes(startTime + ",");
				boolean statFlag = false;
				
								
				while (!statFlag) {
					String state = job.getResourceProperty(JobManagement.RPStatusInfo);
					if (state.contains("SUCCESSFUL")) {
						statFlag = true;
						long statTime = System.currentTimeMillis();
						out.writeBytes(Long.toString(statTime));
						out.writeBytes("\n");
					}
					if (state.contains("FAILED")) {
						statFlag = true;
						System.out.println(state);
						i = i - 1;
					}

				}
			}
			out.writeBytes("# END_RECORD \n");
			out.writeBytes("\n");

		}

	}

	protected JobClient submitJob(TSSClient tss) throws Exception {
		SubmitDocument req = SubmitDocument.Factory.newInstance();
		req.addNewSubmit().setJobDefinition(
				BESUtils.getJSDLFromFile("src/test/resources/jsdl/gridsam.xml").getJobDefinition());
		SubmitResponseDocument res = tss.Submit(req);
		return new JobClient(BASEURL + "/" + UAS.JMS, res.getSubmitResponse()
				.getJobReference(), makeSecurityProperties());
	}



}
