package de.fzj.unicore.bes.functional;

import junit.framework.TestCase;

import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.bes.client.ActivityClient;
import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.security.UsernameOutHandler;
import de.fzj.unicore.bes.util.BESOnStartup;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import eu.emi.security.authn.x509.impl.KeystoreCertChainValidator;
import eu.emi.security.authn.x509.impl.KeystoreCredential;
import eu.unicore.util.httpclient.DefaultClientConfiguration;
import eu.unicore.util.httpclient.IClientConfiguration;

public class BaseActivityTest extends TestCase{
	
	protected boolean useProxyCert = false;
	protected boolean securityFlag = true; 
	protected static IClientConfiguration sp = null;
	protected String protocol = "http";
	protected String serverUrl = null;
	protected static final String hostAddress = "://localhost:7777/services/";
	
	
	
	protected void configureSecurity() throws Exception{
		if(getSecurityFlag()){
			 protocol = "https";
			 if(useProxyCert)sp = makeSecurityPropertiesWithProxy();
			 else sp = makeSecurityProperties();
		}	
		serverUrl = protocol+hostAddress;
	}
	
	protected FactoryClient getDefaultFactory() throws Exception{
		configureSecurity();

		String factoryUrl = serverUrl+"BESFactory";
		EndpointReferenceType eprt = EndpointReferenceType.Factory.newInstance();
		eprt.addNewAddress().setStringValue(factoryUrl+"?res="+BESOnStartup.INSTANCE_ID);

		FactoryClient client = null;
		try {
			client = new FactoryClient(factoryUrl, eprt, sp);
			return client;
		} catch (Exception e) {
			fail();
			e.printStackTrace();
		}
		
		
		return null;
	}
	
	protected EndpointReferenceType getDefaultFactoryEpr(){
		EndpointReferenceType eprt = EndpointReferenceType.Factory.newInstance();
		eprt.addNewAddress().setStringValue(serverUrl+"BESFactory?res="+BESOnStartup.INSTANCE_ID);
		WSServerUtilities.addUGSRefparamToEpr(eprt, BESOnStartup.INSTANCE_ID);
		return eprt;
	}
		
	protected ActivityClient getActivityClient(EndpointReferenceType epr) throws Exception {
		configureSecurity();
		String activityUrl = serverUrl+"BESActivity";
		
		try {
			ActivityClient ac = new ActivityClient(activityUrl, epr, sp);
			return ac;
		} catch (Exception e) {
			fail();
			e.printStackTrace();
		}
		
		return null;
	}
	
	
	


	//programatically setup security
	public static DefaultClientConfiguration makeSecurityProperties() throws Exception {
		String certs="src/main/certs/user-keystore.jks";
		DefaultClientConfiguration secP=new DefaultClientConfiguration();
		secP.setSslEnabled(true);
		secP.setSslAuthn(true);
		secP.setDoSignMessage(true);
		secP.setValidator(new KeystoreCertChainValidator(certs, 
				"the!user".toCharArray(), "jks", -1));
		secP.setCredential(new KeystoreCredential(certs, 
				"the!user".toCharArray(), "the!user".toCharArray(), null, "jks"));
		secP.setOutHandlerClassNames(new String[] {UsernameOutHandler.class.getName()});
		secP.getETDSettings().setExtendTrustDelegation(true);
		sp=secP;
		return secP;
	}


	//programatically setup proxy credentials
	protected IClientConfiguration makeSecurityPropertiesWithProxy() throws Exception{
		if(sp==null){
			String certs="src/main/certs/user-keystore.jks";
			DefaultClientConfiguration secP=new DefaultClientConfiguration();
			secP.setSslEnabled(true);
			secP.setSslAuthn(true);
			secP.setDoSignMessage(true);
			secP.setValidator(new KeystoreCertChainValidator(certs, 
					"the!user".toCharArray(), "jks", -1));
			secP.setCredential(new KeystoreCredential("/tmp/proxy/user-proxy_aa.p12", 
					"the!user".toCharArray(), "the!user".toCharArray(), null, "pkcs12"));
			secP.getETDSettings().setExtendTrustDelegation(true);
			sp=secP;
		}
		return sp;
	}
	
	
	protected void setSecurityFlag(boolean b){
		securityFlag = b; 
	}
	
	protected boolean getSecurityFlag(){
		return securityFlag;
	}
	
	
	
	
	
}
