/*
 * Copyright (c) 2012 ICM Uniwersytet Warszawski All rights reserved.
 * See LICENCE.txt file for licensing information.
 */
package de.fzj.unicore.bes.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.apache.log4j.Logger;

import de.fzj.unicore.uas.UASProperties;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;


public class BESProperties extends PropertiesHelper {
	
	private static final Logger log = Log.getLogger(Log.SERVICES, BESProperties.class);
	
	@DocumentationReferencePrefix
	public static final String PREFIX = UASProperties.PREFIX + "bes.";

	public static final String IS_ACCEPTING_NEW_ACTIVITIES = "isAcceptingNewActivities";
	
	// flag for singleton
	public static final String SINGLE_XNJS = "useSingletonXnjs";

	public static final String NAMING_PROFILE = "namingProfile";

	public static final String LOCAL_RESOURCE_MANAGER_TYPE = "localResourceManagerType";

	public static final String COMMON_NAME = "commonName";

	public static final String LONG_DESCRIPTION = "longDescription";
	
	public static final String BES_EXTENSION = "extension";
	
	public static final String BES_GLUE_PATH = "gluePropertyFile";
	
	// flag differentiating uas or bes job start/abort functions functions
	public static final String BES_JOB_MODE = "jobMode";

	@DocumentationReferenceMeta
	public static final Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();
	static {
		//TODO review me and fill up descriptions
		META.put(IS_ACCEPTING_NEW_ACTIVITIES, new PropertyMD("true").
				setDescription("Controls whether the BES interface accepts new jobs"));
		META.put(SINGLE_XNJS, new PropertyMD("").
				setDescription(""));
		META.put(NAMING_PROFILE, new PropertyMD("").
				setDescription(""));
		META.put(LOCAL_RESOURCE_MANAGER_TYPE, new PropertyMD("").
				setDescription(""));
		META.put(COMMON_NAME, new PropertyMD("").
				setDescription(""));
		META.put(LONG_DESCRIPTION, new PropertyMD("").
				setDescription(""));
		META.put(BES_EXTENSION, new PropertyMD("").
				setDescription(""));
		META.put(BES_GLUE_PATH, new PropertyMD((String)null).setPath().
				setDescription("File containing static GLUE properties"));
		META.put(BES_JOB_MODE, new PropertyMD("bes").
				setDescription("Whether jobs are run in BES or UAS mode"));
	}
	
	public BESProperties(Properties properties) throws ConfigurationException {
		super(PREFIX, properties, META, log);
	}

}
