package de.fzj.unicore.bes.util;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;

import org.apache.log4j.Logger;

import de.fzj.unicore.bes.BES;
import de.fzj.unicore.bes.impl.management.BESFactoryAdmin;
import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.persist.impl.LockSupport;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.KernelInjectable;
import de.fzj.unicore.wsrflite.exceptions.ResourceNotCreatedException;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;

//TODO - use StartupTask 
public class BESOnStartup implements Runnable, KernelInjectable {

	private static final Logger logger = LogUtil.getLogger(LogUtil.UNICORE,BESOnStartup.class);

	public static final String INSTANCE_ID = "default_bes_factory";
	public static final String INIT_ACTIVITY_FLAG = BESOnStartup.class.getName()+ "_activity_key";
	public static final String INIT_NAMING_PROFILE = BESOnStartup.class.getName()+ "_naming_key";
	public static final String INIT_LOCAL_RESOURCE_MANAGER_TYPE = BESOnStartup.class.getName()+ "_resource_manager_key";
	public static final String INIT_COMMON_NAME = BESOnStartup.class.getName()+ "_common_name_key";
	public static final String INIT_LONG_DESCRIPTION = BESOnStartup.class.getName()+ "_long_description_key";
	public static final String INIT_BES_EXTENSION = BESOnStartup.class.getName()+"_bes_extension";	
	public static final String INIT_BES_GLUE_PATH = BESOnStartup.class.getName()+"_bes_glue_path";
	
	private static BESFactoryAdmin besAdminBean;
	
	private Kernel kernel;
	
	public BESOnStartup() {

	}

	public BESOnStartup(Kernel kernel) {
		this.kernel=kernel;
	}
	
	public void setKernel(Kernel kernel){
		this.kernel=kernel;
	}
	
	public synchronized void run() {
		BESProperties cfg = new BESProperties(kernel.getContainerProperties().getRawProperties());
		kernel.addConfigurationHandler(BESProperties.class, cfg);
		
		try {
			logger.info("Initialising backend");
			XNJSFacade.get(null,kernel);
		} catch (Exception e) {
			logger.error("Error initialising backend",e);
			return;
		}

		Home bfHome = kernel.getHome(BES.BF);
		if (bfHome == null) {
			logger.info("BES factory service not deployed at this site.!");
			return;
		}

		if(besAdminBean==null){
			besAdminBean = new BESFactoryAdmin(kernel);
			Kernel.addMBean(besAdminBean, "UNICORE/X-BESFactory");
		}
		
		LockSupport ls=kernel.getPersistenceManager().getLockSupport();
		Lock lock=ls.getOrCreateLock(BESOnStartup.class.getName());

		if(lock.tryLock()){
			try{
				// check if instance already exists
				try {
					//this will throw ResourceUnknowException if resource does not exist
					UASWSResourceImpl bf=(UASWSResourceImpl)bfHome.get(INSTANCE_ID);
					//it exists, so force re-publish
					bf.publish();
					
					//and we are done
					return;
				} catch (ResourceUnknownException e) {
					// ok, does not exist
					try{
						createInstance(cfg, bfHome);
					}catch(ResourceNotCreatedException nce){
						logger.error("Could not setup BES factory.",nce);
					}
				}
				catch(PersistenceException pe){
					throw new RuntimeException(pe);
				}
			}finally{
				lock.unlock();
			}
		}
	}

	private void createInstance(BESProperties cfg, Home bfHome)throws ResourceNotCreatedException{
		Map<String, Object> map = new HashMap<String, Object>();
		map.put(WSResourceImpl.INIT_UNIQUE_ID, INSTANCE_ID);
		map.put(INIT_ACTIVITY_FLAG, cfg.getValue(BESProperties.IS_ACCEPTING_NEW_ACTIVITIES));
		map.put(INIT_NAMING_PROFILE, cfg.getValue(BESProperties.NAMING_PROFILE));
		map.put(INIT_LOCAL_RESOURCE_MANAGER_TYPE, cfg.getValue(BESProperties.LOCAL_RESOURCE_MANAGER_TYPE));
		map.put(INIT_COMMON_NAME, cfg.getValue(BESProperties.COMMON_NAME));
		map.put(INIT_LONG_DESCRIPTION, cfg.getValue(BESProperties.LONG_DESCRIPTION));
		map.put(INIT_BES_EXTENSION, cfg.getValue(BESProperties.BES_EXTENSION));

		String glue = cfg.getValue(BESProperties.BES_GLUE_PATH);
		if (glue==null)
			logger.info("BES GLUE file not configured.");
		else{
			logger.info("Initializing BES GLUE Properties from: "+glue);
			map.put(INIT_BES_GLUE_PATH, glue);
		}

		Calendar c1 = new GregorianCalendar();
		c1.add(Calendar.MONTH, 36);
		map.put(WSResourceImpl.INIT_INITIAL_TERMINATION_TIME, c1);
		bfHome.createWSRFServiceInstance(map);
		logger.info("Added " + INSTANCE_ID + " resource to service " + BES.BF);
	
		logger.info("Initialized BES factory.");
	}

}



