/*********************************************************************************
 * Copyright (c) 2006 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package de.fzj.unicore.bes.impl.wsn;


import javax.xml.namespace.QName;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsn.b2.NotificationProducerRPDocument;
import org.oasisOpen.docs.wsn.b2.SubscribeDocument;
import org.oasisOpen.docs.wsn.b2.SubscribeResponseDocument;

import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.impl.NotificationProducerImpl;


/**
 * @author demuth
 *
 */
public class BESNotificationProducer extends NotificationProducerImpl {

	protected static Logger logger=Logger.getLogger(BESNotificationProducer.class.getName());
	
	public static final String SERVICE_NAME = "BESNotificationProducer";
	public static final String DEFAULT_RES_ID = "default_BESNotificationProducer";
	
	public SubscribeResponseDocument Subscribe(SubscribeDocument req) throws BaseFault {
		logger.trace("Subscribing to GRIS notification producer: " + req.xmlText());
		return super.Subscribe(req);
	}
	


	/* (non-Javadoc)
	 * @see de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl#getResourcePropertyDocumentQName()
	 */
	@Override
	public QName getResourcePropertyDocumentQName() {
		return NotificationProducerRPDocument.type.getDocumentElementName();
	}



	// make these publicly accessable
	/* (non-Javadoc)
	 * @see org.chemomentum.servorch.gris.IGridResourceInfoNotificationProducer#postEvent(javax.xml.namespace.QName, org.apache.xmlbeans.XmlObject[])
	 */
	public void postEvent(QName q, XmlObject[] newValue) {
		
		String notification = "";

		for (int i = 0; i < newValue.length; i++) {
			notification = notification + "\n" + newValue[i].xmlText();
		}
		logger.trace(
			"Sending notification from GRIS:\n" + notification);
		npSupport.postEvent(q, newValue);
		// persist this WS Resource. Notifications are only fired when this gets passivated
		try {
			kernel.getPersistenceManager().persist(this);
		} catch (Exception e) {
			logger.error("Error persisting BES notification: "+e.getMessage(), e);
		}
	}
	


	/* (non-Javadoc)
	 * @see org.chemomentum.servorch.gris.IGridResourceInfoNotificationProducer#addTopic(javax.xml.namespace.QName)
	 */
	public void addTopic(QName q) {
		npSupport.addSimpleTopic(q);
		try {
			kernel.getPersistenceManager().persist(this);
		} catch (Exception e) {
			logger.error("Error persisting BES notification: "+e.getMessage(), e);
		}
	}
}
