package de.fzj.unicore.bes.impl.management;

import java.util.Map;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.admin.AdminAction;
import de.fzj.unicore.wsrflite.admin.AdminActionResult;
import eu.unicore.util.Log;

public class ToggleBESJobSubmissionStatus implements AdminAction {

	@Override
	public String getName() {
		return "ToggleBESJobSubmission";
	}

	@Override
	public String getDescription() {
		return "";
	}

	@Override
	public AdminActionResult invoke(Map<String, String> params, Kernel kernel) {
		boolean success=true;
		String message=null;
		try{
			BESFactoryAdmin admin = kernel.load(BESFactoryAdmin.class);

			String submissionStatus = admin.isJobSubmissionEnabled();
			if(submissionStatus==null){
				success=false;
				message="No BESFactory service available at this site!";
			}
			else{
				boolean enabled=Boolean.parseBoolean(submissionStatus);
				admin.toggleJobSubmissionEnabled();
				enabled = Boolean.parseBoolean(admin.isJobSubmissionEnabled());
				message=enabled?"OK - BES job submission is now enabled" : "OK - BES job submission is disabled";
			}
			return new AdminActionResult(success,message);
		}catch(Exception e){
			return new AdminActionResult(false, Log.createFaultMessage("Can't run action", e));
		}
	}

}
