package de.fzj.unicore.bes.impl.management;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.codehaus.xfire.fault.XFireFault;
import org.ggf.schemas.bes.x2006.x08.besManagement.StartAcceptingNewActivitiesDocument;
import org.ggf.schemas.bes.x2006.x08.besManagement.StartAcceptingNewActivitiesResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besManagement.StopAcceptingNewActivitiesDocument;
import org.ggf.schemas.bes.x2006.x08.besManagement.StopAcceptingNewActivitiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocument;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.bes.BES;
import de.fzj.unicore.bes.BESFactory;
import de.fzj.unicore.bes.BESManagement;
import de.fzj.unicore.bes.util.BESOnStartup;
import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.KernelInjectable;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;



/**
 * 
 * This class implements BESManagement webservice functions. See BESManagement
 * interface for details {@link de.fzj.unicore.BESManagement}.
 * 
 * @author m.memon
 * 
 */
public class BESManagementImpl implements BESManagement, KernelInjectable {

	private static final Logger logger = LogUtil.getLogger(LogUtil.SERVICES,BESManagementImpl.class);

	private Kernel kernel;
	
	public void setKernel(Kernel kernel){
		this.kernel=kernel;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see de.fzj.unicore.bes.BESManagement#StartAcceptingNewActivities(org.ggf.schemas.bes.x2006.x08.besManagement.StartAcceptingNewActivitiesDocument)
	 */
	public StartAcceptingNewActivitiesResponseDocument StartAcceptingNewActivities(StartAcceptingNewActivitiesDocument startRequestDoc)
			throws XFireFault {
		logger.info("Start Accepting New Activities. ");
		StartAcceptingNewActivitiesResponseDocument startResDoc = StartAcceptingNewActivitiesResponseDocument.Factory.newInstance();

		startResDoc.addNewStartAcceptingNewActivitiesResponse();
		try {
			updateActivityFlag(true);
			logger.info("BES is accepting new activities");
		} catch (Exception e) {
			logger.error("Couldn't enforce BES to start accepting new activities.",e);
		}
		return startResDoc;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.fzj.unicore.bes.BESManagement#StopAcceptingNewActivities(org.ggf.schemas.bes.x2006.x08.besManagement.StopAcceptingNewActivitiesDocument)
	 */
	public StopAcceptingNewActivitiesResponseDocument StopAcceptingNewActivities(
			StopAcceptingNewActivitiesDocument stopRequestDoc)
			throws XFireFault {
		logger.info("Stop Accepting New Acivities");
		StopAcceptingNewActivitiesResponseDocument stopResDoc = StopAcceptingNewActivitiesResponseDocument.Factory.newInstance();
		stopResDoc.addNewStopAcceptingNewActivitiesResponse();
		try {
			updateActivityFlag(false);
			logger.info("BES is not accepting any new activities.");
		} catch (Exception e) {
			logger.error("Not possible to stop accepting new activities. ",e);
		}
		return stopResDoc;

	}

	/**
	 * Returns the default BESFactory instance 
	 * (with the lock held, so must release it after use)
	 */
	protected BESFactory getBESInstance() {
		EndpointReferenceType eprt = EndpointReferenceType.Factory.newInstance();
		String baseUrl = kernel.getContainerProperties().getBaseUrl();
		String factoryUrl = baseUrl + "/" + BES.BF + "?res="+ BESOnStartup.INSTANCE_ID;
		eprt.addNewAddress().setStringValue(factoryUrl);
		Home h = kernel.getHome(BES.BF);
		try {
			return (BESFactory)h.getForUpdate(BESOnStartup.INSTANCE_ID);
		} catch (ResourceUnknownException e1) {
			logger.fatal("Resource unknown: ",e1);
		}
		return null;
	}

	protected void releaseBESInstance(BESFactory f)throws PersistenceException{
		Resource r=(Resource)f;
		Home h = kernel.getHome(BES.BF);
		if(r.hasChanged()){
			h.getStore().persist(r);
		}
		h.getStore().unlock(r);
		
	}
	
	
	/**
	 * check method.
	 */
	private String getActivityProperty() throws Exception {
//		FactoryClient client = getFactory();
//		String rp = client.getResourceProperty(BESFactory.RPIsAcceptingNewActivities);
//		return rp;
		 BESFactory bfObj = getBESInstance();
		 GetResourcePropertyDocument gReqDoc =
		 GetResourcePropertyDocument.Factory.newInstance();
		 gReqDoc.setGetResourceProperty(BESFactory.RPIsAcceptingNewActivities);
		 GetResourcePropertyResponseDocument gResDoc = bfObj
		 .GetResourceProperty(gReqDoc);
//		 XmlObject activityObj = Utilities.extractResourceProperty(gResDoc);
		 
		 return gResDoc.getGetResourcePropertyResponse().toString();
	}
 
	

	/**
	 * Update <code>NotAcceptingNewActivities</code> flag of BESFactory.
	 * @param booleanValue
	 */
	private void updateActivityFlag(boolean flag) {

		XmlObject acObj = null;
		XmlCursor acCursor = null;
		try {
			String propertyXml = getActivityProperty();
			logger.debug("IsAcceptingNewActivities resource property: "+ propertyXml);
			acObj = XmlObject.Factory.parse(propertyXml);
			acCursor = acObj.newCursor();

			UpdateResourcePropertiesDocument updateReqDoc = UpdateResourcePropertiesDocument.Factory
					.newInstance();
			UpdateType updateType = updateReqDoc
					.addNewUpdateResourceProperties().addNewUpdate();

			XmlObject newXml = XmlObject.Factory.newInstance();
			XmlCursor cursor = newXml.newCursor();
			cursor.toNextToken();
			cursor.beginElement(BESFactory.RPIsAcceptingNewActivities);
			cursor.insertChars(String.valueOf(flag));
			
			updateType.set(newXml);

			BESFactory f=getBESInstance();
			try{
				f.UpdateResourceProperties(updateReqDoc);
			}finally{
				if(f!=null)releaseBESInstance(f);
			}
			cursor.dispose();
			acCursor.dispose();
		} catch (XmlException e) {
			logger.error("Couldn't update bes resource property",e);
		} catch (Exception e) {
			logger.error("",e);
		}

	}
}
