package de.fzj.unicore.bes.impl.management;


import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.bes.BES;
import de.fzj.unicore.bes.BESFactory;
import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.client.ManagementClient;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;

public class BESFactoryAdmin implements BESFactoryAdminMBean  {
	
	private final Kernel kernel;
	
	public BESFactoryAdmin(Kernel kernel){
		this.kernel=kernel;
	}
	
	@Override
	public String isJobSubmissionEnabled() {
		String factoryUrl = kernel.getContainerProperties().getBaseUrl()+"/" + BES.BF + "?res=default_bes_factory";
		EndpointReferenceType factoryEpr = WSUtilities.makeServiceEPR(factoryUrl);
		XmlCursor cursor = null;
		try {
			FactoryClient factoryCient = new FactoryClient(factoryEpr, kernel.getClientConfiguration());
			String xml = factoryCient.getResourceProperty(BESFactory.RPIsAcceptingNewActivities);
	        XmlObject xmlObj = XmlObject.Factory.parse(xml);
	        cursor = xmlObj.newCursor();
	        cursor.toChild(BESFactory.RPIsAcceptingNewActivities);
	        String s = cursor.getTextValue();
	        cursor.dispose();
	        return s; 
		} catch (Exception e) {
			return null;
		}
	}
	
	@Override
	public synchronized void toggleJobSubmissionEnabled() {
		boolean submissionEnabled = Boolean.parseBoolean(isJobSubmissionEnabled());
		String serviceUrl = kernel.getContainerProperties().getBaseUrl() + "/" + BES.BM;
		try {
			ManagementClient bmClient = new ManagementClient(serviceUrl,kernel.getClientConfiguration());
			if(submissionEnabled) {
				bmClient.stopAcceptingNewActivities();
			}
			else {
				bmClient.startAcceptingNewActivities(); 
			}
		} catch (Exception e) {	}
	}
	
}
