package de.fzj.unicore.bes.impl.factory;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.ggf.baseprofile.FinalWSResourceInterfaceDocument;
import org.ggf.baseprofile.ResourcePropertyNamesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentType;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStatusDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseType;
import org.ggf.schemas.bes.x2006.x08.besFactory.FactoryResourceAttributesDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.FactoryResourceAttributesDocumentType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentResponseType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentsDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentsResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusResponseType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentResponseType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentType;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivityResponseType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.oasisOpen.docs.wsrf.rl2.CurrentTimeDocument.CurrentTime;
import org.oasisOpen.docs.wsrf.rl2.DestroyDocument;
import org.oasisOpen.docs.wsrf.rl2.DestroyResponseDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeResponseDocument;
import org.oasisOpen.docs.wsrf.rl2.TerminationTimeDocument.TerminationTime;
import org.oasisOpen.docs.wsrf.rp2.UpdateResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateResourcePropertiesResponseDocument;
import org.ogf.schemas.glue.x2009.x03.spec20R1.DomainsDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlsoap.schemas.soap.envelope.Fault;

import de.fzj.unicore.bes.BES;
import de.fzj.unicore.bes.BESActivity;
import de.fzj.unicore.bes.BESFactory;
import de.fzj.unicore.bes.factory.rp.ActivityReferenceRP;
import de.fzj.unicore.bes.factory.rp.BESExtensionRP;
import de.fzj.unicore.bes.factory.rp.BasicResourceAttributesDocumentRP;
import de.fzj.unicore.bes.factory.rp.CommonNameRP;
import de.fzj.unicore.bes.factory.rp.FilteredActivityReferenceRP;
import de.fzj.unicore.bes.factory.rp.GlueAttributesRP;
import de.fzj.unicore.bes.factory.rp.IsAcceptingNewActivitiesRP;
import de.fzj.unicore.bes.factory.rp.LocalResourceManagerTypeRP;
import de.fzj.unicore.bes.factory.rp.LongDescriptionRP;
import de.fzj.unicore.bes.factory.rp.NamingProfileRP;
import de.fzj.unicore.bes.factory.rp.TotalNumberOfActivitiesRP;
import de.fzj.unicore.bes.faults.InvalidRequestMessageFault;
import de.fzj.unicore.bes.faults.NotAcceptingNewActivitiesFault;
import de.fzj.unicore.bes.faults.UnknownActivityIdentifierFault;
import de.fzj.unicore.bes.faults.UnsupportedFeatureFault;
import de.fzj.unicore.bes.impl.activity.BESActivityImpl;
import de.fzj.unicore.bes.util.BESOnStartup;
import de.fzj.unicore.bes.util.BESUtils;
import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.impl.bp.BPSupportImpl;
import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.uas.impl.tss.TargetSystemImpl;
import de.fzj.unicore.uas.impl.tss.rp.StorageReferenceResourceProperty;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.exceptions.UnableToSetTerminationTimeException;
import de.fzj.unicore.wsrflite.messaging.Message;
import de.fzj.unicore.wsrflite.messaging.PullPoint;
import de.fzj.unicore.wsrflite.messaging.ResourceDeletedMessage;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceNotDestroyedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.TerminationTimeChangeRejectedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.UnableToSetTerminationTimeFault;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import de.fzj.unicore.xnjs.ems.Action;
import eu.unicore.security.Client;

/**
 * BESFactory implementation
 *
 * @author m.memon
 * @author schuller
 */
public class BESFactoryImpl extends UASWSResourceImpl implements BESFactory {


	private static final Logger logger = LogUtil.getLogger(LogUtil.SERVICES, BESFactoryImpl.class);
	public static final String JSDL = "http://schemas.ggf.org/jsdl/2005/11/jsdl";
	public static final String JSDL_POSIX = "http://schemas.ggf.org/jsdl/2005/11/jsdl-posix";
	public static final String JSDL_HPCP = "http://schemas.ggf.org/jsdl/2006/07/jsdl-hpcp";
	/**
	 * maps ws resource IDs to clients
	 */
	@Persist
	private Map<String, String> owners = new HashMap<String, String>();
	@Persist
	private boolean useGlue = false;

	@Override
	protected void addWSResourceInterfaces(BPSupportImpl baseProfile) {
		super.addWSResourceInterfaces(baseProfile);
		baseProfile.addWSResourceInterface(BES_PORT);
	}

	@Override
	public void customPostActivate() {
		// check for the deleted activities and remove them from resource property.

		try {
			logger.trace("Getting messages from queue " + getUniqueID());
			PullPoint p = kernel.getMessaging().getPullPoint(getUniqueID());
			ActivityReferenceRP acRP = (ActivityReferenceRP) properties.get(RPActivityReference);

			while (p.hasNext()) {
				Message m = p.next();
				logger.trace("Read: " + m);
				if (m instanceof ResourceDeletedMessage) {
					ResourceDeletedMessage rdm = (ResourceDeletedMessage) m;
					String id = rdm.getDeletedResource();
					String service = rdm.getServiceName();
					if (BES.BA.equals(service)) {
						acRP.remove(id);
						owners.remove(id);
						setDirty();
					}
				}
			}
		} catch (Exception e) {
			LogUtil.logException(e.getMessage(), e, logger);
		}

	}

	@Override
	public void initialise(String serviceName, Map<String, Object> initObjs) throws Exception {
		super.initialise(serviceName, initObjs);

		logger.info("Initializing BESFactory with ID: " + getUniqueID());

		Boolean activityFlag = Boolean.valueOf((String) initObjs.get(BESOnStartup.INIT_ACTIVITY_FLAG));

		String namingProfile = (String) initObjs.get(BESOnStartup.INIT_NAMING_PROFILE);

		String besExtension = (String) initObjs.get(BESOnStartup.INIT_BES_EXTENSION);

		String glueFilePath = (String) initObjs.get(BESOnStartup.INIT_BES_GLUE_PATH);

		String resourceManagerType = (String) initObjs.get(BESOnStartup.INIT_LOCAL_RESOURCE_MANAGER_TYPE);
		String commonName = (String) initObjs.get(BESOnStartup.INIT_COMMON_NAME);
		String longDesc = (String) initObjs.get(BESOnStartup.INIT_LONG_DESCRIPTION);

		properties.put(RPIsAcceptingNewActivities, new IsAcceptingNewActivitiesRP(activityFlag));
		properties.put(RPNamingProfile, new NamingProfileRP(namingProfile));
		properties.put(RPLocalResourceManagerType, new LocalResourceManagerTypeRP(resourceManagerType));
		properties.put(RPTotalNumberOfActivities, new TotalNumberOfActivitiesRP(this, xnjsReference));
		properties.put(RPCommonName, new CommonNameRP(commonName));
		properties.put(RPLongDescription, new LongDescriptionRP(longDesc));
		properties.put(RPActivityReference, new ActivityReferenceRP(this));
		properties.put(RPBasicResourceAttributes, new BasicResourceAttributesDocumentRP(this, xnjsReference));
		properties.put(RPFilteredActivityReference, new FilteredActivityReferenceRP(this));
		properties.put(RPBESExtension, new BESExtensionRP(besExtension));

		if (glueFilePath != null) {
			properties.put(RPGlueProperties, new GlueAttributesRP(this, getGlueDocument(glueFilePath), xnjsReference));
			useGlue = true;
		} else {
			useGlue = false;
		}

		publish();
	}

	/**
	 * @param filePath
	 * @return
	 */
	protected DomainsDocument getGlueDocument(String filePath) {
		DomainsDocument d;
		try {
			d = DomainsDocument.Factory.parse(new File(filePath));
			return d;
		} catch (XmlException e) {
			logger.error("Couldn't build glue instance document from file: "
					+ filePath + "\n", e);

		} catch (IOException e) {
			logger.error("Couldn't find glue instance file", e);
		}
		return null;
	}

	public String getOwnerForActivity(String activityID) {
		return owners.get(activityID);
	}

	@Override
	public CreateActivityResponseDocument CreateActivity(
			CreateActivityDocument req) throws NotAcceptingNewActivitiesFault,
			InvalidRequestMessageFault, UnsupportedFeatureFault {

		if (!getIsAcceptingNewActivitiesProperty().getProperty().booleanValue()) {
			throw new NotAcceptingNewActivitiesFault("NotAcceptingNewActvities Error");
		}
		if (logger.isTraceEnabled()) {
			logger.trace(req.toString());
		}

		ActivityDocumentType activityDescription = req.getCreateActivity().getActivityDocument();

		JobDefinitionType jobType = activityDescription.getJobDefinition();
		checkJobValidity(jobType);

		Map<String, Object> initParams = new HashMap<String, Object>();

		ActivityDocumentDocument1 aDoc = ActivityDocumentDocument1.Factory.newInstance();
		aDoc.setActivityDocument(activityDescription);

		EndpointReferenceDocument factoryEPR = EndpointReferenceDocument.Factory.newInstance();
		factoryEPR.setEndpointReference(getEPR());

		// setting properties for BES Activity
		initParams.put(BESActivity.ACTIVITY_DOC_KEY, aDoc);
		initParams.put(BESActivity.FACTORY_REF_KEY, factoryEPR);

		// setting jsdl document
		JobDefinitionDocument doc = JobDefinitionDocument.Factory.newInstance();
		doc.setJobDefinition(jobType);

		Action action = XNJSFacade.get(xnjsReference,kernel).makeAction(doc);

		initParams.put(BESActivity.INIT_ACTION_KEY, action);
		initParams.put(INITPARAM_XNJS_REFERENCE, xnjsReference);

		//extend the lifetime of besfactory if required
		TerminationTime itt = req.getCreateActivity().getActivityDocument().getTerminationTime();
		if (itt != null && itt.getCalendarValue() != null) {
			Calendar jobTT = itt.getCalendarValue();
			initParams.put(INIT_INITIAL_TERMINATION_TIME, jobTT);
			try {
				checkAndExtendLT(jobTT);
			} catch (UnableToSetTerminationTimeException te) {
				LogUtil.logException("Could not extend termination time of BES factory.", te, logger);
			}
		}

		EndpointReferenceType instanceEPR = null;
		try {
			// creating BESActivity instance using initial parameters
			instanceEPR = createJobInstance(initParams);
			Client client = getClient();
			if (client != null) {
				owners.put(WSServerUtilities.extractResourceID(instanceEPR), client.getDistinguishedName());
			}
		} catch (Exception e) {
			LogUtil.logException("Couldn't create BESActivity: ", e, logger);
		}
		CreateActivityResponseDocument crResDoc = CreateActivityResponseDocument.Factory.newInstance();
		CreateActivityResponseType crResType = crResDoc.addNewCreateActivityResponse();
		if (instanceEPR != null) {
			crResType.setActivityIdentifier(instanceEPR);
			crResType.setActivityDocument(activityDescription);
			getActivityReferenceProperty().add(instanceEPR);
		}
		setDirty();

		if (logger.isDebugEnabled()) {
			logger.debug(crResDoc.toString());
		}
		return crResDoc;
	}

	@Override
	public GetActivityDocumentsResponseDocument GetActivityDocuments(GetActivityDocumentsDocument req) throws UnknownActivityIdentifierFault {

		EndpointReferenceType[] requestedActivities = req.getGetActivityDocuments().getActivityIdentifierArray();

		GetActivityDocumentResponseType[] result = new GetActivityDocumentResponseType[requestedActivities.length];

		Map<String, Boolean> eprMap = checkIfAccessible(requestedActivities);

		int counter = 0;
		Home localHome = kernel.getHome(BES.BA);

		for (EndpointReferenceType requested : requestedActivities) {
			Boolean accessible = eprMap.get(requested.getAddress().getStringValue());
			result[counter] = GetActivityDocumentResponseType.Factory.newInstance();
			result[counter].setActivityIdentifier(requested);
			BESActivityImpl besActivity = null;
			try {
				besActivity = (BESActivityImpl) localHome.get(WSServerUtilities.extractResourceID(requested));
			} catch (Exception r) {
				Fault soapFault = BESUtils.buildSOAP11Fault(UnknownActivityIdentifierFaultNS, "Given activity doesn't exist");
				result[counter].setFault(soapFault);
				counter++;
				continue;
			}

			if (Boolean.TRUE.equals(accessible)) {
				JobDefinitionType job = besActivity.getActivityDocumentProperty().getActivityDocument().getJobDefinition();
				result[counter].setJobDefinition(job);
				result[counter].setActivityLog(besActivity.getActivityLog());
			} else {//exists, but is not accessible
				Fault soapFault = BESUtils.buildSOAP11Fault(NotAuthorizedFaultNS, "Given activity is not accessible");
				result[counter].setFault(soapFault);
			}
			counter++;
		}

		GetActivityDocumentsResponseDocument responseDoc = GetActivityDocumentsResponseDocument.Factory.newInstance();
		responseDoc.addNewGetActivityDocumentsResponse().setResponseArray(result);
		if (logger.isDebugEnabled()) {
			logger.debug(responseDoc.toString());
		}
		return responseDoc;
	}

	@Override
	public GetActivityStatusesResponseDocument GetActivityStatuses(GetActivityStatusesDocument req) throws UnknownActivityIdentifierFault {

		EndpointReferenceType[] requestedActivities = req.getGetActivityStatuses().getActivityIdentifierArray();

		GetActivityStatusResponseType[] result = new GetActivityStatusResponseType[requestedActivities.length];

		Map<String, Boolean> eprMap = checkIfAccessible(requestedActivities);

		int counter = 0;
		Home localHome = kernel.getHome(BES.BA);
		for (EndpointReferenceType requested : requestedActivities) {
			Boolean accessible = eprMap.get(requested.getAddress().getStringValue());
			result[counter] = GetActivityStatusResponseType.Factory.newInstance();
			result[counter].setActivityIdentifier(requested);
			BESActivityImpl besActivity = null;
			try {
				besActivity = (BESActivityImpl) localHome.get(WSServerUtilities.extractResourceID(requested));
			} catch (Exception r) {
				Fault soapFault = BESUtils.buildSOAP11Fault(UnknownActivityIdentifierFaultNS, "Given activity doesn't exist");
				result[counter].setFault(soapFault);
				counter++;
				continue;
			}
			if (Boolean.TRUE.equals(accessible)) {
				try {
					result[counter].setActivityStatus(besActivity.getStatusProperty().getActivityStatus());
				} catch (Exception ex) {
					LogUtil.logException("Can't get state for " + requested, ex, logger);
				}
			} else {//exists, but is not accessible
				Fault soapFault = BESUtils.buildSOAP11Fault(NotAuthorizedFaultNS, "Given activity is not accessible");
				result[counter].setFault(soapFault);
			}
			counter++;
		}

		GetActivityStatusesResponseDocument responseDoc = GetActivityStatusesResponseDocument.Factory.newInstance();
		responseDoc.addNewGetActivityStatusesResponse().setResponseArray(result);
		if (logger.isDebugEnabled()) {
			logger.debug(responseDoc.toString());
		}
		return responseDoc;
	}

	/**
	 * Same as GetResourcePropertyDocument. It returns
	 * FactoryResourceAttributesDocument.
	 * 
	 */
	@Override
	public GetFactoryAttributesDocumentResponseDocument GetFactoryAttributesDocument(
			GetFactoryAttributesDocumentDocument1 req) {

		GetFactoryAttributesDocumentResponseDocument resDoc = GetFactoryAttributesDocumentResponseDocument.Factory.newInstance();
		GetFactoryAttributesDocumentResponseType res = resDoc.addNewGetFactoryAttributesDocumentResponse();

		try {
			res.set(getResourcePropertyResponseDocument(req.getGetFactoryAttributesDocument()));
		} catch (Exception e) {
			LogUtil.logException("", e, logger);
		}
		if (logger.isDebugEnabled()) {
			logger.debug(resDoc.toString());
		}
		return resDoc;
	}

	@Override
	public TerminateActivitiesResponseDocument TerminateActivities(TerminateActivitiesDocument req)
	throws UnknownActivityIdentifierFault {

		EndpointReferenceType[] requestedActivities = req.getTerminateActivities().getActivityIdentifierArray();
		TerminateActivityResponseType[] result = new TerminateActivityResponseType[requestedActivities.length];

		Home localHome = kernel.getHome(BES.BA);
		Map<String, Boolean> eprMap = checkIfAccessible(requestedActivities);

		int counter = 0;

		for (EndpointReferenceType requested : requestedActivities) {
			result[counter] = TerminateActivityResponseType.Factory.newInstance();
			result[counter].setActivityIdentifier(requested);

			BESActivityImpl besActivity = null;
			try {
				besActivity = (BESActivityImpl) localHome.get(WSServerUtilities.extractResourceID(requested));
			} catch (Exception r) {
				Fault soapFault = BESUtils.buildSOAP11Fault(UnknownActivityIdentifierFaultNS, "Given activity doesn't exist");
				result[counter].setFault(soapFault);
				counter++;
				continue;
			}
			Boolean accessible = eprMap.get(requested.getAddress().getStringValue());
			String activityId = WSUtilities.extractResourceID(requested);
			if (Boolean.TRUE.equals(accessible)) {
				try {
					ActivityStatusDocument status = besActivity.getStatusProperty();
					if (logger.isDebugEnabled()) {
						logger.debug(status.toString());
					}
					try {
						XNJSFacade.get(xnjsReference,kernel).getManager().abort(activityId, getClient());
					} catch (Exception e) {
						String desc = "Activity could not be cancelled";
						result[counter].setFault(BESUtils.buildSOAP11Fault(new QName("TerminateActivityFault"), desc));
						counter++;
						continue;
					}
					result[counter].setTerminated(true);
				} catch (Exception ex) {
					String desc = "Activity could not be cancelled: Error getting activity info.";
					result[counter].setFault(BESUtils.buildSOAP11Fault(new QName("TerminateActivityFault"), desc));
				}
			} else {
				result[counter].setFault(BESUtils.buildSOAP11Fault(UnknownActivityIdentifierFaultNS, "Activity does not exist."));
			}
			counter++;
		}

		TerminateActivitiesResponseDocument res = TerminateActivitiesResponseDocument.Factory.newInstance();
		res.addNewTerminateActivitiesResponse().setResponseArray(result);
		if (logger.isDebugEnabled()) {
			logger.debug(res.toString());
		}
		return res;
	}


	@Override
	public UpdateResourcePropertiesResponseDocument UpdateResourceProperties(
			UpdateResourcePropertiesDocument in) throws BaseFault {
		logger.debug("Updating IsAcceptingNewActivitiesProperty resource property");

		XmlCursor updateCursor = in.getUpdateResourceProperties().getUpdate().newCursor();

		updateCursor.toFirstContentToken();

		// again putting the resource properties
		properties.put(RPIsAcceptingNewActivities, new IsAcceptingNewActivitiesRP(Boolean.valueOf(updateCursor.getTextValue())));

		updateCursor.dispose();

		UpdateResourcePropertiesResponseDocument updateResDoc = UpdateResourcePropertiesResponseDocument.Factory.newInstance();

		updateResDoc.addNewUpdateResourcePropertiesResponse();
		setDirty();
		return updateResDoc;
	}

	// create additional storages defined in the config file...
	//TODO - review me, I'm not sure if this is what was wanted: for all site storages defined, BES will create its own instance, right?
	protected void createAdditionalStorages() {
		Collection<StorageDescription> storages =uasProperties.getAddonStorages();
		for (StorageDescription a : storages) {
			createStorageResource(a);
			logger.debug("Added " + a.toString());
		}
	}

	protected void createStorageResource(StorageDescription sd) {
		logger.debug("Creating Storage Resource");
		StorageReferenceResourceProperty srp = (StorageReferenceResourceProperty) properties.get(
				TargetSystemImpl.RPStorageReference);

		Map<String, Object> initMap = new HashMap<String, Object>();
		initMap.put(SMSBaseImpl.INIT_STORAGE_DESCRIPTION, sd);

		// set "infinite" tt, because the SMS will be destroyed together with
		// this TSS
		Calendar tt = Calendar.getInstance();
		tt.add(Calendar.YEAR, 50);
		initMap.put(SMSBaseImpl.INIT_INITIAL_TERMINATION_TIME, tt);
		initMap.put(INITPARAM_XNJS_REFERENCE, xnjsReference);

		EndpointReferenceType smsEpr = createStorageManagement(initMap);
		srp.add(smsEpr);
	}

	/**
	 * creates new storage management service (SMS) and returns its epr
	 * 
	 * @param - initParam map of initialization parameters
	 * @return EPR or <code>null</code> if SMS could not be created
	 */
	protected EndpointReferenceType createStorageManagement(
			Map<String, Object> initParam) {
		try {
			logger.debug("Creating Storage Management Resource");
			String id = kernel.getHome(UAS.SMS).createWSRFServiceInstance(initParam);
			return WSServerUtilities.makeEPR(UAS.SMS, id, StorageManagement.SMS_PORT, kernel);
		} catch (Exception e) {
			logger.warn("Could not create storage management service.", e);
		}
		return null;
	}

	/**
	 * create new job and return its epr
	 * 
	 * @param - initParam map of initialization parameters
	 * @return EPR
	 */
	protected EndpointReferenceType createJobInstance(
			Map<String, Object> initParam) throws Exception {
		String id = kernel.getHome(BES.BA).createWSRFServiceInstance(initParam);
		return WSServerUtilities.makeEPR(BES.BA, id, BESActivity.ACTIVITY_PORT, kernel);
	}

	/**
	 * extends termination time of a job
	 * 
	 * if user submits a job with a tt longer than the TSS lifetime
	 * automatically extend the TSS lifetime : copied from TSS code
	 * @param newTT - new termination time
	 */
	protected void checkAndExtendLT(Calendar newTT) throws UnableToSetTerminationTimeException {
		if (getTerminationTime().compareTo(newTT) < 0) {
			logger.debug("Job termination time exceeds BES termination time, extending BES lifetime...");
			Calendar tt = (Calendar) newTT.clone();
			tt.add(Calendar.DATE, 1);
			setTerminationTime(tt);
		}
	}

	@Override
	public XmlObject getResourcePropertyResponseDocument() {
		return getResourcePropertyResponseDocument(null);
	}

	/**
	 * Build the ResourceProperties document, filtered using the supplied GetFactoryAttributesDocument
	 * 
	 */
	public XmlObject getResourcePropertyResponseDocument(GetFactoryAttributesDocumentType getFactAttType) {
		FactoryResourceAttributesDocumentDocument1 fDoc = FactoryResourceAttributesDocumentDocument1.Factory.newInstance();
		FactoryResourceAttributesDocumentType factoryAttributesType = fDoc.addNewFactoryResourceAttributesDocument();

		int num = 0;
		try {
			num = ((TotalNumberOfActivitiesRP) properties.get(RPTotalNumberOfActivities)).update().getProperty();
		} catch (Exception e1) {
			logger.error("Couldn't get TotalNumberOfActivities RP: ", e1);
		}

		factoryAttributesType.setTotalNumberOfActivities(num);

		// since no scheduler is available, therefore the contained resources
		// is 0
		factoryAttributesType.setTotalNumberOfContainedResources(0);

		if (getFactAttType == null) {
			GetFactoryAttributesDocumentDocument1 getFactAttDoc = GetFactoryAttributesDocumentDocument1.Factory.newInstance();
			getFactAttType = getFactAttDoc.addNewGetFactoryAttributesDocument();
		}

		Node node = getFactAttType.getDomNode();
		if (node.getFirstChild() != null) {
			logger.debug("BasicFilter is present.");
			NodeList nList = node.getFirstChild().getChildNodes();

			for (int i = 0; i < nList.getLength(); i++) {
				Node n = nList.item(i);

				if (n.getNodeName().contains("ActivityReferences")) {
					// if ActivityReferences is true then append all activities'
					// eprs
					// inside resource property document
					if (n.getFirstChild().getNodeValue().equals("true")) {
						if (num > 0) {
							factoryAttributesType.addNewActivityReference();
							factoryAttributesType.setActivityReferenceArray(getFilteredActivityReferenceProperty().getProperty());
						}

					}
				}

				// additional check of Containedresources will be added,
				// once bes job scheduler is available.
				// Hence no action has to be done if the ContainedResources
				// element is true or false.
			}
		} else { // if there is no BasicFilter element, then append
			// ActivityReferences
			if (num > 0) {
				factoryAttributesType.addNewActivityReference();
				factoryAttributesType.setActivityReferenceArray(getFilteredActivityReferenceProperty().getProperty());
			}
			factoryAttributesType.setIsAcceptingNewActivities(getIsAcceptingNewActivitiesProperty().getProperty());

		}

		factoryAttributesType.setLocalResourceManagerType((String) properties.get(BESFactory.RPLocalResourceManagerType).getProperty());
		factoryAttributesType.setCommonName((String) properties.get(BESFactory.RPCommonName).getProperty());
		factoryAttributesType.setLongDescription((String) properties.get(BESFactory.RPLongDescription).getProperty());

		// changed function call from QName to String parameter
		factoryAttributesType.setNamingProfileArray(new String[]{(String) properties.get(
				BESFactory.RPNamingProfile).getProperty()});

		factoryAttributesType.setBESExtensionArray((String[]) properties.get(
				BESFactory.RPBESExtension).getProperty());

		try {
			BasicResourceAttributesDocumentRP basicResourceRP = ((BasicResourceAttributesDocumentRP) properties.get(BESFactory.RPBasicResourceAttributes)).update();
			logger.debug(basicResourceRP.getProperty().toString());
			factoryAttributesType.setBasicResourceAttributesDocument(basicResourceRP.getProperty());
		} catch (Exception e) {
			logger.error("Couldn't add Basic Resource Attributes Document", e);
		}

		if (useGlue) {
			// appending glue properties
			GlueAttributesRP glueRP = (GlueAttributesRP) properties.get(BESFactory.RPGlueProperties);
			factoryAttributesType.setDomains(glueRP.getXml()[0].getDomains());
		}

		// set current time
		factoryAttributesType.setCurrentTime(getCurrentTime());

		// set termination time
		TerminationTime tt = TerminationTime.Factory.newInstance();
		tt.setCalendarValue(getTerminationTime());
		factoryAttributesType.setTerminationTime(tt);

		factoryAttributesType.setWSResourceInterfaces(getWSResourceInterfaces().getWSResourceInterfaces());
		factoryAttributesType.setFinalWSResourceInterface(getFinalWSInterface());
		factoryAttributesType.setResourceEndpointReference(getEPR());
		factoryAttributesType.setResourcePropertyNames(getRPNames().getResourcePropertyNames());

		if (logger.isDebugEnabled()) {
			logger.debug("FactoryAttributesDocument: " + fDoc.toString());
		}

		return fDoc;
	}

	/**
	 * For each incoming EPR, it is checked if it is valid. A map is returned that mapping activity URLs
	 * to <code>Boolean.TRUE</code> iff the activity exists on this factory and is accessible to the current client.
	 * 
	 * @param requestedEPRs - an array of BES activity EPRs
	 */
	protected Map<String, Boolean> checkIfAccessible(EndpointReferenceType[] requestedEPRs) {
		FilteredActivityReferenceRP ap= getFilteredActivityReferenceProperty();
		// holds URLs from EPRs with flag true or false for identifying resolved and unresolved eprs
		Map<String, Boolean> result = new HashMap<String, Boolean>();
		for (EndpointReferenceType epr : requestedEPRs) {
			String url = epr.getAddress().getStringValue();
			boolean canAccess = ap.isAccessible(epr);
			result.put(url, canAccess);
		}
		return result;
	}

	@Override
	public QName getResourcePropertyDocumentQName() {
		return FactoryResourceAttributesDocumentDocument1.type.getDocumentElementName();
	}

	@Override
	public QName getPortType() {
		return BES_PORT;
	}

	/**
	 * TODO this does not do anything yet.
	 * @param jobType
	 * @throws InvalidRequestMessageFault
	 */
	protected void checkJobValidity(JobDefinitionType jobType) throws InvalidRequestMessageFault {
		//NOP
	}

	public ActivityReferenceRP getActivityReferenceProperty() {
		return (ActivityReferenceRP) properties.get(BESFactory.RPActivityReference);
	}

	public FilteredActivityReferenceRP getFilteredActivityReferenceProperty() {
		return (FilteredActivityReferenceRP) properties.get(BESFactory.RPFilteredActivityReference);
	}

	public IsAcceptingNewActivitiesRP getIsAcceptingNewActivitiesProperty() {
		return (IsAcceptingNewActivitiesRP) properties.get(BESFactory.RPIsAcceptingNewActivities);
	}

	public CurrentTime getCurrentTime() {
		CurrentTime ct = CurrentTime.Factory.newInstance();
		ct.setCalendarValue(Calendar.getInstance());
		return ct;
	}

	public QName getFinalWSInterface() {
		ImmutableResourceProperty imp = (ImmutableResourceProperty) properties.get(BPSupportImpl.RPFinalWSResourceInterface);
		return ((FinalWSResourceInterfaceDocument) imp.getXml()[0]).getFinalWSResourceInterface();
	}

	public ResourcePropertyNamesDocument getRPNames() {
		try {
			ImmutableResourceProperty imp = (ImmutableResourceProperty) BPSupportImpl.getRPNamesProperty(properties.keySet());
			return (ResourcePropertyNamesDocument) imp.getXml()[0];
		} catch (Exception e) {
			LogUtil.logException("Couldn't get resource property names: ", e, logger);
			return null;
		}
	}

	@Override
	public DestroyResponseDocument Destroy(DestroyDocument in) throws ResourceNotDestroyedFault, ResourceUnknownFault, ResourceUnavailableFault {
		throw ResourceNotDestroyedFault.createFault("Not destroyed.");
	}

	@Override
	public SetTerminationTimeResponseDocument SetTerminationTime(
			SetTerminationTimeDocument in)
	throws UnableToSetTerminationTimeFault,
	TerminationTimeChangeRejectedFault, ResourceUnknownFault,
	ResourceUnavailableFault {
		throw TerminationTimeChangeRejectedFault.createFault("Not changed.");
	}
}
