package de.fzj.unicore.bes.impl.activity;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.bes.x2006.x08.besActivity.ActivityResourceAttributesDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besActivity.ActivityResourceAttributesDocumentType;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStatusDocument;
import org.unigrids.x2006.x04.services.jms.AbortDocument;
import org.unigrids.x2006.x04.services.jms.AbortResponseDocument;
import org.unigrids.x2006.x04.services.jms.HoldDocument;
import org.unigrids.x2006.x04.services.jms.HoldResponseDocument;
import org.unigrids.x2006.x04.services.jms.ResumeDocument;
import org.unigrids.x2006.x04.services.jms.ResumeResponseDocument;
import org.unigrids.x2006.x04.services.jms.StartDocument;
import org.unigrids.x2006.x04.services.jms.StartResponseDocument;
import org.unigrids.x2006.x04.services.jms.SubmissionTimeDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.bes.BESActivity;
import de.fzj.unicore.bes.activity.rp.ActivityDocumentRP;
import de.fzj.unicore.bes.activity.rp.ActivityFactoryReferenceRP;
import de.fzj.unicore.bes.activity.rp.StatusRP;
import de.fzj.unicore.bes.util.BESProperties;
import de.fzj.unicore.uas.JobManagement;
import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.impl.bp.BPSupportImpl;
import de.fzj.unicore.uas.impl.job.JobManagementImpl;
import de.fzj.unicore.uas.impl.job.StdErrProperty;
import de.fzj.unicore.uas.impl.job.StdOutProperty;
import de.fzj.unicore.uas.impl.job.WorkingDirResourceProperty;
import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.uas.impl.sms.StorageManagementHomeImpl.StorageTypes;
import de.fzj.unicore.uas.impl.tss.rp.StorageReferenceResourceProperty;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.messaging.ResourceDeletedMessage;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import de.fzj.unicore.xnjs.ems.Action;
import eu.unicore.security.Client;

/**
 * BESActivity Implementation class.
 * 
 * @author m.memon, a.memon
 **/
public class BESActivityImpl extends UASWSResourceImpl implements BESActivity {

	private static final Logger logger = LogUtil.getLogger(LogUtil.SERVICES, BESActivityImpl.class);
	@Persist
	private String factoryID;

	@Override
	protected void addWSResourceInterfaces(BPSupportImpl baseProfile) {
		super.addWSResourceInterfaces(baseProfile);
		baseProfile.addWSResourceInterface(ACTIVITY_PORT);
	}

	@Override
	public QName getPortType() {
		return ACTIVITY_PORT;
	}

	@Override
	public void initialise(String serviceName, Map<String, Object> initParams) throws Exception {

		Action action = (Action) initParams.get(BESActivity.INIT_ACTION_KEY);
		//override our uniqueID with the action UUID
		initParams.put(INIT_UNIQUE_ID, action.getUUID());

		super.initialise(serviceName, initParams);

		EndpointReferenceDocument factoryEPR = (EndpointReferenceDocument) initParams.get(BESActivity.FACTORY_REF_KEY);

		factoryID = WSServerUtilities.extractResourceID(factoryEPR.getEndpointReference());

		ActivityDocumentDocument1 aDoc = (ActivityDocumentDocument1) initParams.get(BESActivity.ACTIVITY_DOC_KEY);

		BESProperties cfg = kernel.getAttribute(BESProperties.class);
		if ("bes".equals(cfg.getValue(BESProperties.BES_JOB_MODE))) {
			//tell XNJS to auto-run the job when it goes to READY state
			action.getProcessingContext().put(Action.AUTO_SUBMIT, Boolean.TRUE);
		}

		logger.info("Submitting BESActivity <" + getUniqueID() + "> for client " + getClient());
		XNJSFacade.get(xnjsReference,kernel).getConfiguration().getEMSManager().add(action, getClient());


		if (logger.isDebugEnabled()) {
			logger.debug("The Factory EPR in Activity Service:  " + factoryEPR.toString());
			logger.debug("BESActivity: " + aDoc.toString());
			logger.debug("activity status in properties map:  " + properties.get(RPStatus));
		}

		properties.put(BESActivity.RPStatus, new StatusRP(this, xnjsReference, getUniqueID()));
		properties.put(BESActivity.RPFactoryReference, new ActivityFactoryReferenceRP(factoryEPR));
		properties.put(BESActivity.RPActivityDocument, new ActivityDocumentRP(aDoc));

		//working directory
		WorkingDirResourceProperty workDir = new WorkingDirResourceProperty(createUspace(action, getClient()));
		properties.put(JobManagement.RPWorkingDir, workDir);


		//any additional storage references
		EndpointReferenceType[] smsEprs = (EndpointReferenceType[]) initParams.get(JobManagementImpl.INITPARAM_STORAGE_REFERENCE);
		if (smsEprs != null) {
			StorageReferenceResourceProperty sp = new StorageReferenceResourceProperty(smsEprs);
			properties.put(JobManagementImpl.RPStorageReference, sp);
		}


		// setting stdout /sterr resource property
		// this property has not yet been set as a part of resource property document
		properties.put(JobManagementImpl.STDOUT, new StdOutProperty(this, action.getUUID(), xnjsReference));
		properties.put(JobManagementImpl.STDERR, new StdErrProperty(this, action.getUUID(), xnjsReference));


		//submission time
		SubmissionTimeDocument std = SubmissionTimeDocument.Factory.newInstance();
		std.setSubmissionTime(Calendar.getInstance());
		properties.put(JobManagementImpl.RPSubmissionTime, new ImmutableResourceProperty(std));



		setDirty();

		//publish this in registry?
		if (Boolean.TRUE.equals(initParams.get(INITPARAM_PUBLISH_TO_REGISTRY))) {
			logger.debug("Publishing into the Registry");
			publish();
		}

	}

	/**
	 * creates a storage management service for the job
	 * @param initParams
	 * @return
	 */
	protected EndpointReferenceType createStorageManagementService(Map<String, Object> initParams) {
		try {
			Home smsHome = kernel.getHome(UAS.SMS);
			String id = smsHome.createWSRFServiceInstance(initParams);
			return WSServerUtilities.makeEPR(UAS.SMS, id, StorageManagement.SMS_PORT, kernel);
		} catch (Exception e) {
			LogUtil.logException("Could not create storage for job", e, logger);
		}
		return null;
	}

	/**
	 * creates the Uspace SMS instance
	 * @param a - XNJS Action
	 * @param c - Client
	 * @return the EPR of the newly created Uspace
	 */
	protected EndpointReferenceType createUspace(Action a, Client c) {
		Map<String, Object> initMap = new HashMap<String, Object>();
		StorageDescription description = new StorageDescription("Uspace-"+getUniqueID(), "Uspace", 
				a.getExecutionContext().getWorkingDirectory(), 
				StorageTypes.VARIABLE, null, null, false, false, false, a.getUmask(), 
				"Job's workspace", null);
		initMap.put(SMSBaseImpl.INIT_STORAGE_DESCRIPTION, description);
		//align terminationtime 
		initMap.put(INIT_INITIAL_TERMINATION_TIME,
				getResourcePropertyObject(RPterminationTimeQName));
		initMap.put(INITPARAM_XNJS_REFERENCE, xnjsReference);

		return createStorageManagementService(initMap);
	}


	/* (non-Javadoc)
	 * @see de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl#getResourcePropertyResponseDocument()
	 */
	@Override
	public XmlObject getResourcePropertyResponseDocument() {

		ActivityResourceAttributesDocumentDocument1 attributeDoc = ActivityResourceAttributesDocumentDocument1.Factory.newInstance();
		ActivityResourceAttributesDocumentType at = attributeDoc.addNewActivityResourceAttributesDocument();

		ActivityFactoryReferenceRP factoryRefRP = (ActivityFactoryReferenceRP) properties.get(RPFactoryReference);
		at.setFactoryReference(factoryRefRP.getFactoryEPR().getEndpointReference());

		ActivityDocumentRP activityDocRP = (ActivityDocumentRP) properties.get(RPActivityDocument);
		at.setActivityDocument(activityDocRP.getActivityDoc().getActivityDocument());

		StatusRP statusRP = (StatusRP) properties.get(RPStatus);
		at.setStatus(statusRP.getXml()[0].getActivityStatus());

		at.setActivityDocument(activityDocRP.getActivityDoc().getActivityDocument());
		at.setFactoryReference(factoryRefRP.getFactoryEPR().getEndpointReference());

		return attributeDoc;
	}

	/* (non-Javadoc)
	 * @see de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl#getResourcePropertyDocumentQName()
	 */
	@Override
	public QName getResourcePropertyDocumentQName() {
		return ActivityResourceAttributesDocumentDocument1.type.getDocumentElementName();
	}

	/**
	 * resource-specific destruction: send message about our demise
	 */
	@Override
	public void destroy() {

		try {
			ResourceDeletedMessage m = new ResourceDeletedMessage("deleted:" + getUniqueID());
			m.setServiceName(getServiceName());
			m.setDeletedResource(getUniqueID());
			kernel.getMessaging().getChannel(factoryID).publish(m);
		} catch (Exception e) {
			LogUtil.logException("Could not send internal message.", e, logger);
		}

		//clean up on backend
		try {
			XNJSFacade.get(xnjsReference,kernel).destroyAction(getUniqueID(), getClient());
		} catch (Exception e) {
			LogUtil.logException("Could not destroy job on XNJS.", e, logger);
		}

		super.destroy();
	}

	@Override
	public StartResponseDocument Start(StartDocument in) throws BaseFault {
		StartResponseDocument res = StartResponseDocument.Factory.newInstance();
		try {
			XNJSFacade.get(xnjsReference,kernel).getManager().run(getUniqueID(), getClient());
			res.addNewStartResponse();
			logger.info("Started " + getUniqueID());
			return res;
		} catch (Exception e) {
			String msg = "Could not start job " + getUniqueID();
			LogUtil.logException(msg, e, logger);
			throw BaseFault.createFault(msg, e);
		}
	}

	@Override
	public AbortResponseDocument Abort(AbortDocument in) throws BaseFault {
		AbortResponseDocument res = AbortResponseDocument.Factory.newInstance();
		try {
			XNJSFacade.get(xnjsReference,kernel).getManager().abort(getUniqueID(), getClient());
			res.addNewAbortResponse();
			return res;
		} catch (Exception e) {
			String msg = "Could not abort job " + getUniqueID();
			LogUtil.logException(msg, e, logger);
			throw BaseFault.createFault(msg, e);
		}
	}

	@Override
	public HoldResponseDocument Hold(HoldDocument in) throws BaseFault {
		HoldResponseDocument res = HoldResponseDocument.Factory.newInstance();
		try {
			XNJSFacade.get(xnjsReference,kernel).getManager().pause(getUniqueID(), getClient());
			res.addNewHoldResponse();
			return res;
		} catch (Exception e) {
			String msg = "Could not hold job " + getUniqueID();
			LogUtil.logException(msg, e, logger);
			throw BaseFault.createFault(msg, e);
		}
	}

	@Override
	public ResumeResponseDocument Resume(ResumeDocument in) throws BaseFault {
		ResumeResponseDocument res = ResumeResponseDocument.Factory.newInstance();
		try {
			XNJSFacade.get(xnjsReference,kernel).getManager().resume(getUniqueID(), getClient());
			res.addNewResumeResponse();
			return res;
		} catch (Exception e) {
			String msg = "Could not resume job " + getUniqueID();
			LogUtil.logException(msg, e, logger);
			throw BaseFault.createFault(msg, e);
		}
	}

	public ActivityStatusDocument getStatusProperty() throws Exception {
		StatusRP statusRP = (StatusRP) properties.get(RPStatus);
		ActivityStatusDocument asDoc = statusRP.update().getProperty();
		return asDoc;
	}

	public EndpointReferenceDocument getActivityFactoryReferenceProperty() throws Exception {
		ActivityFactoryReferenceRP factoryRP = (ActivityFactoryReferenceRP) properties.get(RPFactoryReference);
		return factoryRP.getFactoryEPR();
	}

	public ActivityDocumentDocument1 getActivityDocumentProperty() {
		ActivityDocumentRP activityDocRP = (ActivityDocumentRP) properties.get(RPActivityDocument);
		return activityDocRP.getActivityDoc();
	}

	public String getActivityLog() {
		try {
			StringBuilder sb = new StringBuilder();
			List<String> l = XNJSFacade.get(xnjsReference,kernel).getAction(getUniqueID()).getLog();
			for (String s : l) {
				sb.append(s).append("\n");
			}
			return sb.toString();
		} catch (Exception ex) {
			return "Error getting activity log: " + ex;
		}
	}
}
