package de.fzj.unicore.bes.factory.rp;


import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

import de.fzj.unicore.bes.BESFactory;
import de.fzj.unicore.bes.impl.factory.BESFactoryImpl;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

/**
 * TotalNumberOfActivities resource property property holds 
 * the total number of activities managed by BESFactory and  
 * accessible to a user requesting. 
 * 
 * @author m.memon
 */

public class TotalNumberOfActivitiesRP extends ResourceProperty<Integer> {

	private static final long serialVersionUID = -1591307540154742975L;

	private Integer jobs;
	
	public TotalNumberOfActivitiesRP(Resource parent, String xnjsReference) {
		super(parent);
	}

	@Override
	public XmlObject[] getXml() {
		XmlObject xml = XmlObject.Factory.newInstance();
		XmlCursor cursor = xml.newCursor();
		cursor.toNextToken();
		cursor.beginElement(BESFactory.RPTotalNumberOfActivities);
		cursor.insertChars(Integer.toString(jobs));
		cursor.dispose();
		return new XmlObject[] { xml };
	}

	@Override
	public TotalNumberOfActivitiesRP update() throws Exception {
		jobs=((BESFactoryImpl)parentWSResource).getFilteredActivityReferenceProperty().getNumberOfElements();
		return this;
	}

	@Override
	public Integer getProperty() {
		return jobs;
	}

}
