package de.fzj.unicore.bes.factory.rp;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

public final class NamingProfileRP extends ResourceProperty<String> {

	private static final long serialVersionUID = -8531282287269635825L;

	private String namingProfile = null;

	private final static Logger logger = LogUtil.getLogger(LogUtil.SERVICES,NamingProfileRP.class);

	public NamingProfileRP(String namingProfile) {
		super(null);
		setProperty(namingProfile);
	}
	
	@Override
	public String getProperty() {
		return namingProfile;
	}

	@Override
	public void setProperty(String namingProfile) {
		this.namingProfile = namingProfile;
	}

	@Override
	public XmlObject[] getXml() {
		String xmlResult = "<bes-factory:NamingProfile "
				+ "xmlns:bes-factory='http://schemas.ggf.org/bes/2006/08/bes-factory'>"
				+namingProfile+"</bes-factory:NamingProfile>";
		XmlObject xmlResultDoc = null;
		try {
			xmlResultDoc = XmlObject.Factory.parse(xmlResult);
			return new XmlObject[] { xmlResultDoc };
		} catch (XmlException e) {
			LogUtil.logException("Can't parse XML",e,logger);
			return new XmlObject[] {};
		}
	}

}
