package de.fzj.unicore.bes.factory.rp;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;



public final class LongDescriptionRP extends ResourceProperty<String> {

	private static final long serialVersionUID = 2867269598321980664L;

	private static final Logger logger = LogUtil.getLogger(LogUtil.SERVICES,LongDescriptionRP.class);

	private String longDescription = null;

	public LongDescriptionRP(String longDesc) {
		super(null);
		setProperty(longDesc);
	}
	
	@Override
	public XmlObject[] getXml() {
		String xmlResult = "<bes:LongDescription "
				+ "xmlns:bes='http://schemas.ggf.org/bes/2006/08/bes-factory'>"
				+ longDescription + "</bes:LongDescription>";
		XmlObject xmlResultDoc = null;
		try {
			xmlResultDoc = XmlObject.Factory.parse(xmlResult);
			return new XmlObject[] { xmlResultDoc };
		} catch (XmlException e) {
			LogUtil.logException("Couldn't construct XML for LongDescription property",e,logger);
			return new XmlObject[] {};
		}
		
	}

	@Override
	public String getProperty() {
		return longDescription;
	}
	
	@Override
	public void setProperty(String commonName) {
		this.longDescription = commonName;
	}
}
