package de.fzj.unicore.bes.factory.rp;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

public final class LocalResourceManagerTypeRP extends ResourceProperty<String> {

	private static final long serialVersionUID = 8939396152201176525L;

	private final static Logger logger = LogUtil.getLogger(LogUtil.SERVICES,LocalResourceManagerTypeRP.class);

	private String resourceManagerType = null;

	public LocalResourceManagerTypeRP(String rmType) {
		super(null);
		setProperty(rmType);
	}

	@Override
	public XmlObject[] getXml() {
		String xmlResult = "<bes:LocalResourceManagerType "
				+ "xmlns:bes='http://schemas.ggf.org/bes/2006/08/bes-factory'>"
				+ resourceManagerType + "</bes:LocalResourceManagerType>";
		XmlObject xmlResultDoc = null;
		try {
			xmlResultDoc = XmlObject.Factory.parse(xmlResult);
			return new XmlObject[] { xmlResultDoc };
		} catch (XmlException e) {
			LogUtil.logException("Couldn't construct XML for LocalResourceManagerType property", e, logger);
			return new XmlObject[]{};
		}
	}

	@Override
	public String getProperty() {
		return resourceManagerType;
	}

	@Override
	public void setProperty(String resourceManagerType) {
		this.resourceManagerType = resourceManagerType;
	}

}
