package de.fzj.unicore.bes.factory.rp;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

public final class IsAcceptingNewActivitiesRP extends ResourceProperty<Boolean> {

	private static final long serialVersionUID = -8411382267101629674L;

	private Boolean acceptingNewActivities = true;

	private final static Logger logger = LogUtil.getLogger(LogUtil.SERVICES, TotalNumberOfActivitiesRP.class);

	public IsAcceptingNewActivitiesRP(Boolean acceptingNewActivities) {
		super(null);
		this.setProperty(acceptingNewActivities);
	}

	@Override
	public XmlObject[] getXml() {
		String xmlDoc = "<IsAcceptingNewActivities "
				+ "xmlns='http://schemas.ggf.org/bes/2006/08/bes-factory'>"
				+ acceptingNewActivities + "</IsAcceptingNewActivities>";
		XmlObject xmlResultDoc = null;
		try {
			xmlResultDoc = XmlObject.Factory.parse(xmlDoc);
			return new XmlObject[] { xmlResultDoc };
		} catch (XmlException e) {
			LogUtil.logException("Couldn't construct XML",e,logger);
			return new XmlObject[] {};
		}
	}
	
	@Override
	public Boolean getProperty() {
		return acceptingNewActivities;
	}

	@Override
	public void setProperty(Boolean acceptingNewActivities) {
		this.acceptingNewActivities = acceptingNewActivities;
	}
	
}
