package de.fzj.unicore.bes.factory.rp;

import org.ogf.schemas.glue.x2009.x03.spec20R1.ApplicationEnvironmentT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ApplicationEnvironmentsDocument.ApplicationEnvironments;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingEndpointT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingManagerT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingServiceT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.DomainsDocument;

import de.fzj.unicore.bes.impl.factory.BESFactoryImpl;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;


/**
 * Glue resource properties
 * */
public class GlueAttributesRP extends ResourceProperty<DomainsDocument>{

	private static final long serialVersionUID = -4931735801831100110L;
	
	private DomainsDocument domainsDoc;  
	
	private final String xnjsReference; 
	
	private final String endpointId = "urn:fzj:jsc:vsgc:bes";
	
	
	public GlueAttributesRP(BESFactoryImpl parent, DomainsDocument domain, String xnjsReference){
		super(parent);
		this.domainsDoc = domain;
		this.xnjsReference = xnjsReference;	
	}
	
	@Override
	public DomainsDocument[] getXml(){
		embedBESProperties();
		return new DomainsDocument[]{domainsDoc};
	}

	@Override
	public void setProperty(DomainsDocument setTo) {
		domainsDoc = setTo;
	}
		
	/**
	 * This method inserts the BES's dynamic properties such as
	 * wsdl url, start time and issuer ca dn
	 */
	protected void embedBESProperties(){
		Kernel kernel=parentWSResource.getKernel();
		ComputingServiceT cs = domainsDoc.getDomains().getAdminDomainArray()[0].getComputingServiceArray()[0];
		ComputingEndpointT ct = cs.getComputingEndpointArray()[0];
		
		String url = kernel.getContainerProperties().getBaseUrl()+"/"+parentWSResource.getServiceName();
		String wsdl = url+"?wsdl";
		ct.setWSDLArray(new String[]{wsdl});		
		ct.setStartTime(kernel.getUpSince());
		ct.setInterfaceName("OGSABES:"+parentWSResource.getServiceName());
		ct.setID(endpointId+":"+parentWSResource.getUniqueID());
		
		if (((BESFactoryImpl)parentWSResource).getOwner() != null){
			String issuerCa = ((BESFactoryImpl)parentWSResource).getOwner().getName(); 
			if(issuerCa != null)ct.setIssuerCA(issuerCa);
		}
		ct.setURL(url);
		
		 
		ComputingManagerT crt = null;
		// if there are more than 0 applications available
		if(getApplicationTypes().getApplicationEnvironmentArray().length > 0){
			crt = ComputingManagerT.Factory.newInstance();
			crt.setApplicationEnvironments(getApplicationTypes());
			cs.setComputingManagerArray(new ComputingManagerT[]{crt});
		}
	}

	protected ApplicationEnvironments getApplicationTypes(){
		Kernel kernel=parentWSResource.getKernel();
		ApplicationInfo[] appsInfo=XNJSFacade.get(xnjsReference, kernel).getDefinedApplications();
		ApplicationEnvironments appEnvs = ApplicationEnvironments.Factory.newInstance();
		for (int i = 0; i < appsInfo.length; i++) {
			ApplicationEnvironmentT appt = appEnvs.addNewApplicationEnvironment();
			appt.setAppName(appsInfo[i].getApplicationName());
			appt.setAppVersion(appsInfo[i].getApplicationVersion());
		}
		return appEnvs;
	}

	
}


