package de.fzj.unicore.bes.factory.rp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.bes.BES;
import de.fzj.unicore.bes.impl.factory.BESFactoryImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import eu.unicore.security.Client;
import eu.unicore.security.OperationType;

public class FilteredActivityReferenceRP extends ResourceProperty<EndpointReferenceType[]> {

	private static final long serialVersionUID = 0L;

	private static final Logger logger = LogUtil.getLogger(LogUtil.SERVICES,FilteredActivityReferenceRP.class);

	public FilteredActivityReferenceRP(BESFactoryImpl parent){
		super(parent);
	}

	@Override
	public EndpointReferenceDocument[] getXml() {

		List<EndpointReferenceDocument> result = new ArrayList<EndpointReferenceDocument>();
		EndpointReferenceDocument[] eprs = null;
		try {
			eprs = (EndpointReferenceDocument[]) ((BESFactoryImpl)parentWSResource).getActivityReferenceProperty().update().getXml();
		} catch (Exception e) {
			logger.error("Couldn't fetch EPRs ", e);
			eprs = new EndpointReferenceDocument[0];
		}
		for(EndpointReferenceDocument epr : eprs)
		{
			if(isAccessible(epr.getEndpointReference())) result.add(epr);
		}
		return result.toArray(new EndpointReferenceDocument[result.size()]);

	}


	//checks whether the local service referenced by epr is accessible
	public boolean isAccessible(EndpointReferenceType epr){	
		try{
			Client c=((BESFactoryImpl)parentWSResource).getClient();
			String serviceName=BES.BA;
			String wsResourceID=WSServerUtilities.extractResourceID(epr);
			String ownerDN=((BESFactoryImpl)parentWSResource).getOwnerForActivity(wsResourceID);
			Map<String, Set<OperationType>> voMembership = ((BESFactoryImpl)parentWSResource).getVOMembership();
			return parentWSResource.getKernel().getSecurityManager().isAccessible(c, serviceName, 
					wsResourceID, ownerDN, voMembership);
		}catch(Exception ex){
			LogUtil.logException("Cannot access server endpoint.", ex, logger);
		}
		return false;
	}


	@Override
	public EndpointReferenceType[] getProperty() {
		List<EndpointReferenceType> result = new ArrayList<EndpointReferenceType>();
		EndpointReferenceType[] eprs = null;
		try {
			eprs = ((BESFactoryImpl)parentWSResource).getActivityReferenceProperty().update().getProperty();
		} catch (Exception e) {
			logger.error("Couldn't fetch EPRs ", e);
			eprs = new EndpointReferenceType[0];
		}
		for(EndpointReferenceType epr : eprs)
		{
			if(isAccessible(epr)) result.add(epr);
		}
		return result.toArray(new EndpointReferenceType[result.size()]);
	}

}
