package de.fzj.unicore.bes.factory.rp;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

public class CommonNameRP extends ResourceProperty<String> {

	private static final long serialVersionUID = 8534843057795079112L;

	private final static Logger logger = LogUtil.getLogger(LogUtil.SERVICES,CommonNameRP.class);

	private String commonName;

	public CommonNameRP(String cName) {
		super(null);
		setProperty(cName);
	}

	@Override
	public XmlObject[] getXml() {
		String xmlResult = "<bes:CommonName "
				+ "xmlns:bes='http://schemas.ggf.org/bes/2006/08/bes-factory'>"
				+ commonName + "</bes:CommonName>";
		XmlObject xmlResultDoc = null;
		try {
			xmlResultDoc = XmlObject.Factory.parse(xmlResult);
			return new XmlObject[] { xmlResultDoc };
		} catch (XmlException e) {
			LogUtil.logException("Couldn't construct XML for CommonName property: ",e,logger);
			return new XmlObject[] {};
		}
	}

	@Override
	public String getProperty() {
		return commonName;
	}
	
	@Override
	public void setProperty(String commonName) {
		this.commonName = commonName;
	}


}
