package de.fzj.unicore.bes.factory.rp;

import org.ggf.schemas.bes.x2006.x08.besFactory.BasicResourceAttributesDocumentType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.RangeValueType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;

import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.impl.SecuredResourceImpl;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import eu.unicore.security.Client;

public class BasicResourceAttributesDocumentRP extends ResourceProperty<BasicResourceAttributesDocumentType> {

	private static final long serialVersionUID = 2195249725570941816L;
	
	BasicResourceAttributesDocumentType resourceDoc = null; 
	
	private final String xnjsReference;
	
	public BasicResourceAttributesDocumentRP(Resource res, String xnjsRef) {
		super(res);
		this.xnjsReference = xnjsRef;
		resourceDoc = BasicResourceAttributesDocumentType.Factory.newInstance();
	}
	
	
	@Override
	public BasicResourceAttributesDocumentType[] getXml() {
		return new BasicResourceAttributesDocumentType[]{resourceDoc};
	}

	
	@Override
	public BasicResourceAttributesDocumentRP update() throws Exception {
		Client client = ((SecuredResourceImpl) parentWSResource).getClient();
		Kernel kernel = parentWSResource.getKernel();
		ResourcesType res = XNJSFacade.get(xnjsReference, kernel).getResources(client);
		
		if(res.getCPUArchitecture()!= null){
			resourceDoc.setCPUArchitecture(res.getCPUArchitecture());
		}
		
		if(res.getTotalPhysicalMemory() != null){
			resourceDoc.setPhysicalMemory(getMaximum(res.getTotalPhysicalMemory()));
		}
			
		//CPUs can be either given as total, or as nodes*cpusPerNode
		if(res.getTotalCPUCount()!= null){
			resourceDoc.setCPUCount(getMaximum(res.getTotalCPUCount()));
		}
		else if(res.getIndividualCPUCount()!=null && res.getTotalResourceCount()!=null){
			int nodes=(int)getMaximum(res.getTotalResourceCount());
			int cpusPerNode=(int)getMaximum(res.getIndividualCPUCount());
			resourceDoc.setCPUCount(nodes*cpusPerNode);	
		}
		
		if(res.getOperatingSystem()!= null){
			resourceDoc.setOperatingSystem(res.getOperatingSystem());
		}
		return this;
	}
	
	@Override
	public BasicResourceAttributesDocumentType getProperty() {
		return resourceDoc;
	}
	
	//retrieve the upper limit specified by the given JSDL range
	private double getMaximum(RangeValueType range){
		double value = 0;
		try{
			value = range.getRangeArray()[0].getUpperBound().getDoubleValue();
		}
		catch(Exception e){
			value = range.getExactArray()[0].getDoubleValue();
		}
		return value;
	}
	
}
