package de.fzj.unicore.bes.factory.rp;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

import de.fzj.unicore.bes.BESFactory;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

public class BESExtensionRP extends ResourceProperty<String[]> {
	
	private static final long serialVersionUID = -5936988679686360462L;

	private static final Logger logger = LogUtil.getLogger(LogUtil.SERVICES,BESExtensionRP.class);

	private final XmlObject[] extensions;
	          
	private final String[] extArray;
	
	public BESExtensionRP(String str){
		super(null);
		if(str!=null){
			logger.info("BESExtension support: "+str);
			extArray=str.split(" +");
			extensions=formatExtensions(extArray);
		}else {
			extArray=new String[0];
			extensions=new XmlObject[0];
		}
	}

	@Override
	public XmlObject[] getXml() {
		return extensions;
	}

	
	private XmlObject[] formatExtensions(String[] extensions){
		List<XmlObject>res=new ArrayList<XmlObject>();
		for (String ext: extensions) {
			String result = "<bes:BESExtension "
					+ "xmlns:bes='"+BESFactory.BES_NS+"'>"
					+ext
					+"</bes:BESExtension>";
			logger.debug("bes-ext: "+ext);
			try {
				res.add(XmlObject.Factory.parse(result));
			} catch (XmlException e1) {
				logger.error("Invalid extension: "+ext,e1);
			}
		}
		return res.toArray(new XmlObject[res.size()]);
	}
	
	@Override
	public String[] getProperty(){
		return extArray;
	}

}

