package de.fzj.unicore.bes.factory.rp;

import org.w3.x2005.x08.addressing.EndpointReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.wsrflite.Resource;

/**
 * 
 * Class representing Activity Reference resource property
 * 
 * @author m.memon
 *
 */
public class ActivityReferenceRP extends ActivityBaseProperty {

	private static final long serialVersionUID = -5696136753103280675L;
	
	public ActivityReferenceRP(Resource p) {
		super(p);
	}
	
	@Override
	public EndpointReferenceDocument[] getXml() {
		EndpointReferenceType[] types = getProperty();
		if(types == null || types.length == 0) return new EndpointReferenceDocument[0];
		EndpointReferenceDocument[] result = new EndpointReferenceDocument[types.length];
		for(int i = 0; i < types.length; i ++)
		{
			EndpointReferenceType epr = types[i];
			EndpointReferenceDocument doc = EndpointReferenceDocument.Factory.newInstance();
			doc.addNewEndpointReference();
			doc.setEndpointReference(epr);
			result[i] = doc;
		}
		return result;
	}

}
