package de.fzj.unicore.bes.factory.rp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.bes.BES;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

public abstract class ActivityBaseProperty extends ResourceProperty<EndpointReferenceType[]> {

	private static final long serialVersionUID = 0L;

	private static final Logger logger=LogUtil.getLogger(LogUtil.SERVICES,ActivityBaseProperty.class);
	
	private String ACTIVITY_BASE;

	private List<String> uuids = new ArrayList<String>();

	public ActivityBaseProperty(Resource p) {
		super(p);
		ACTIVITY_BASE=WSServerUtilities.makeAddress(BES.BA, "", p.getKernel().getContainerProperties());
	}

	public ActivityBaseProperty() {
		this(null);
	}


	/**
	 * @param EndpointReferenceType[]
	 */
	@Override
	public void setProperty(EndpointReferenceType[] types) {
		List<String> newUuids = new ArrayList<String>();
			for(int i=0;i<types.length;i++){
				newUuids.add(WSServerUtilities.extractResourceID(types[i]));
			}
		this.uuids = newUuids;
	}



	@Override
	public int getNumberOfElements(){
		return uuids.size();
	}

	public void add(EndpointReferenceType epr){
		synchronized(uuids){
			uuids.add(WSServerUtilities.extractResourceID(epr));
		}
	}

	/**
	 * remove an entry by ID
	 * @param id - the id of the TSS to remove
	 */
	public void remove(String id){
		synchronized (uuids) {
			Iterator<String> it=uuids.iterator();
			while(it.hasNext()){
				try{
					if(it.next().equals(id)){
						it.remove();
						logger.debug("Removed "+id);
					}
				}catch(Exception e){
					logger.warn(e.getMessage());
				}
			}
		}
	}

	@Override
	public EndpointReferenceType[] getProperty() {
		EndpointReferenceType[] res=new EndpointReferenceType[uuids.size()];
		int i=0;
		String[] idArr = null;
		synchronized (uuids) {
			idArr = uuids.toArray(new String[uuids.size()]);
		}
		for(String uuid : idArr){
			res[i++]=makeEPR(uuid);
		}
		return res;
	}

	protected EndpointReferenceType makeEPR(String id){
		EndpointReferenceType epr=EndpointReferenceType.Factory.newInstance();
		epr.addNewAddress().setStringValue(ACTIVITY_BASE+id);
		return epr;
	}

	public List<String>getUUIDs(){
		return uuids;
	}

	public void addAll(List<String>ids){
		synchronized(uuids){
			uuids.addAll(ids);
		}
	}
}
