package de.fzj.unicore.bes.activity.rp;

import org.apache.log4j.Logger;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStateEnumeration;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStatusDocument;

import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.xnjs.ems.ActionStatus;

/** Resource property class encapsulates activity state */
public class StatusRP extends ResourceProperty<ActivityStatusDocument> {

    private static final long serialVersionUID = 1259816507639273424L;
    private static final Logger logger = Logger.getLogger(StatusRP.class);
    ActivityStatusDocument asDoc = null;
    private String xnjsReference;
    private String actionId;
    private Integer status = null;

    public StatusRP(Resource parent, String xnjsRef, String actionId) {
        super(parent);
        this.xnjsReference = xnjsRef;
        asDoc = ActivityStatusDocument.Factory.newInstance();
        asDoc.addNewActivityStatus().setState(ActivityStateEnumeration.PENDING);
        this.actionId = actionId;
    }

    @Override
    public ActivityStatusDocument[] getXml() {
        return new ActivityStatusDocument[]{asDoc};
    }

    @Override
    public ActivityStatusDocument getProperty() {
        return asDoc;
    }

    public void setproperty(ActivityStatusDocument asDoc) {
        this.asDoc = asDoc;
    }

    @Override
    public StatusRP update() throws Exception {
    	Kernel k=parentWSResource.getKernel();
        status = XNJSFacade.get(xnjsReference, k).getAction(actionId).getStatus();
        asDoc = BESActivityConverter.getBESStatefromXNJSState(k, xnjsReference, actionId, status);
        if (logger.isDebugEnabled()) {
            logger.debug("Job with Id: " + actionId + "state is: " + ActionStatus.toString(status));
            logger.debug(asDoc.toString());
        }
        return this;
    }
}
