/*********************************************************************************
 * Copyright (c) 2006 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package de.fzj.unicore.bes.security;

import org.apache.log4j.Logger;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.handler.Phase;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import eu.unicore.security.xfireutil.client.Configurable;

/**
 * 
 * @author m.memon
 * @deprecated this shouldn't be used! The user name and password (while very limited as BES specific) should be 
 * sent using (a)  Web Services Security UsernameToken Profile 1.1. (b) using digest from this spec, not plain passwords.
 * Server side should be modified accordingly. 
 */
public class UsernameOutHandler extends AbstractHandler implements Configurable {

    protected IClientConfiguration sec;
    private static final Logger logger = Log.getLogger(Log.SECURITY, UsernameOutHandler.class);
    public final static String WSS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public final static String WSS_SECURITY = "Security";
    private String username, password;
    private boolean activateUsernameProfile = false;

    /**
     * creates a new handler for adding username/password to the SOAP message
     */
    public UsernameOutHandler() {
        setPhase(Phase.POLICY);
    }

    @Override
    public void configure(IClientConfiguration sec) {
        this.sec = sec;
        username = sec.getExtraSettings().getProperty(SecurityConstant.ATTR_USERNAME);
        password = sec.getExtraSettings().getProperty(SecurityConstant.ATTR_PASSWORD);
        boolean activateDefault = username != null;
        activateUsernameProfile = Boolean.valueOf(sec.getExtraSettings().getProperty(
                SecurityConstant.ATTR_ACTIVATEUSERNAMEPROFILE, String.valueOf(activateDefault)));

        //sanity check the supplied parameters
        if (password == null) {
            password = "";
        }
        if (activateUsernameProfile && username == null) {
            throw new IllegalArgumentException("Username/password handler enabled, but username was null.");
        }
    }

    @Override
    public void invoke(MessageContext ctx) throws Exception {

        if (!activateUsernameProfile) {
            return;
        }

        Element h = ctx.getOutMessage().getOrCreateHeader();
        h.addContent(getUsernameTokenHeader());

        if (logger.isDebugEnabled()) {
            XMLOutputter o = new XMLOutputter();
            o.setFormat(Format.getPrettyFormat());
            logger.trace("Sending username/password: " + o.outputString(h));
        }

    }

    public Element getUsernameTokenHeader() {
        Element my = new Element(WSS_SECURITY);
        my.setNamespace(Namespace.getNamespace("wsse", SecurityConstant.WSS));
        my.setAttribute("mustUnderstand", "1");
        Element unameTokenElement = new Element(SecurityConstant.WSS_USERNAME_SECURITY_TOKEN, Namespace.getNamespace("wsse", SecurityConstant.WSS));
        Element unameElement = new Element(SecurityConstant.USERNAME, Namespace.getNamespace("wsse", SecurityConstant.WSS));
        unameElement.addContent(username);
        Element pwdElement = new Element(SecurityConstant.PASSWORD, Namespace.getNamespace("wsse", SecurityConstant.WSS));
        pwdElement.addContent(password);
        unameTokenElement.addContent(unameElement);
        unameTokenElement.addContent(pwdElement);
        my.addContent(unameTokenElement);
        return my;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String pwd) {
        this.password = pwd;
    }

    public String getUserName() {
        return username;
    }

    public void setUserName(String userName) {
        this.username = userName;
    }

    public boolean isActivateUsernameProfile() {
        return activateUsernameProfile;
    }

    public void setActivateUsernameProfile(boolean activateUsernameProfile) {
        this.activateUsernameProfile = activateUsernameProfile;
    }
}
