package de.fzj.unicore.bes.faults;

import javax.xml.namespace.QName;

import org.ggf.schemas.bes.x2006.x08.besFactory.UnsupportedFeatureFaultDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.UnsupportedFeatureFaultType;

import de.fzj.unicore.bes.util.ActivityUtils;

public class UnsupportedFeatureFault extends XmlBeansFault{

	private static final long serialVersionUID=1L;
	
	private UnsupportedFeatureFaultType faultDetail;
	
	
	public UnsupportedFeatureFault(String message, Throwable cause, UnsupportedFeatureFaultType details){
		super(message,cause, details);
		this.faultDetail=details;
	}
	
	//this one seems to be required by Xfire?!
	public UnsupportedFeatureFault(String message, UnsupportedFeatureFaultType details){
		super(message);
		this.faultDetail=details;
	}

	public UnsupportedFeatureFault(String message){
		super(message);
	}
	
	public UnsupportedFeatureFaultType getFaultInfo() {
		return faultDetail;
	}
	
	public static QName getFaultName() {
		return UnsupportedFeatureFaultDocument.type.getDocumentElementName();
	}
	
	/**
	/* helper for creating a Fault including the SOAP1.1 element
	*/
	public static UnsupportedFeatureFault createFault(String message){
		UnsupportedFeatureFaultType naf= UnsupportedFeatureFaultType.Factory.newInstance();
		QName faultCode = new QName("bes",UnsupportedFeatureFaultType.class.getName());
		naf.set(ActivityUtils.buildSOAP11Fault(faultCode, message));
		UnsupportedFeatureFault n=new UnsupportedFeatureFault(message,naf);
		return n;
	}
}
