package de.fzj.unicore.bes.faults;

import javax.xml.namespace.QName;

import org.ggf.schemas.bes.x2006.x08.besFactory.UnknownActivityIdentifierFaultDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.UnknownActivityIdentifierFaultType;

import de.fzj.unicore.bes.util.ActivityUtils;


public class UnknownActivityIdentifierFault extends XmlBeansFault{
		
		private static final long serialVersionUID=1L;
	
		private UnknownActivityIdentifierFaultType faultDetail;
	
		public UnknownActivityIdentifierFault(String message, Throwable cause, UnknownActivityIdentifierFaultType details){
			super(message,cause, details);
			this.faultDetail=details;
		}
		
		//this one seems to be required by Xfire?!
		public UnknownActivityIdentifierFault(String message, UnknownActivityIdentifierFaultType details){
			super(message);
			this.faultDetail=details;
		}

		public UnknownActivityIdentifierFault(String message){
			super(message);
		}
		
		public UnknownActivityIdentifierFaultType getFaultInfo() {
			return faultDetail;
		}
		
		public static QName getFaultName() {
			return UnknownActivityIdentifierFaultDocument.type.getDocumentElementName();
		}
		
		/**
		/* helper for creating a Fault including the SOAP1.1 element
		*/
		public static UnknownActivityIdentifierFault createFault(String message){
			UnknownActivityIdentifierFaultType naf= UnknownActivityIdentifierFaultType.Factory.newInstance();
			QName faultCode = new QName("bes",UnknownActivityIdentifierFault.class.getName());
			naf.set(ActivityUtils.buildSOAP11Fault(faultCode, message));
			UnknownActivityIdentifierFault n=new UnknownActivityIdentifierFault(message,naf);
			return n;
		}
		

}
