package de.fzj.unicore.bes.faults;

import javax.xml.namespace.QName;

import org.ggf.schemas.bes.x2006.x08.besFactory.NotAcceptingNewActivitiesFaultDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.NotAcceptingNewActivitiesFaultType;

import de.fzj.unicore.bes.util.ActivityUtils;

public class NotAcceptingNewActivitiesFault extends XmlBeansFault {

	private static final long serialVersionUID=1L;
	
	private NotAcceptingNewActivitiesFaultType faultDetail;
	
	
	public NotAcceptingNewActivitiesFault(String message, Throwable cause, NotAcceptingNewActivitiesFaultType details){
		super(message,cause, details);
		this.faultDetail=details;
	}
	
	//this one seems to be required by Xfire?!
	public NotAcceptingNewActivitiesFault(String message, NotAcceptingNewActivitiesFaultType details){
		super(message);
		this.faultDetail=details;
	}

	public NotAcceptingNewActivitiesFault(String message){
		super(message);
	}
	
	public NotAcceptingNewActivitiesFaultType getFaultInfo() {
		return faultDetail;
	}
	
	public static QName getFaultName() {
		return NotAcceptingNewActivitiesFaultDocument.type.getDocumentElementName();
	}
	
	/**
	/* helper for creating a Fault including the SOAP1.1 element
	*/
	public static NotAcceptingNewActivitiesFault createFault(String message){
		NotAcceptingNewActivitiesFaultType naf= NotAcceptingNewActivitiesFaultType.Factory.newInstance();
		QName faultCode = new QName("bes",NotAcceptingNewActivitiesFault.class.getName());
		naf.set(ActivityUtils.buildSOAP11Fault(faultCode, message));
		NotAcceptingNewActivitiesFault n=new NotAcceptingNewActivitiesFault(message,naf);
		return n;
	}
	

	
	
	
	
	 
}
