package de.fzj.unicore.bes.faults;

import javax.xml.namespace.QName;

import org.ggf.schemas.bes.x2006.x08.besFactory.InvalidRequestMessageFaultDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.InvalidRequestMessageFaultType;

import de.fzj.unicore.bes.util.ActivityUtils;


public class InvalidRequestMessageFault extends XmlBeansFault{
		
		private static final long serialVersionUID=1L;
	
		private InvalidRequestMessageFaultType faultDetail;
	
		public InvalidRequestMessageFault(String message, Throwable cause, InvalidRequestMessageFaultType details){
			super(message,cause, details);
			this.faultDetail=details;
		}
		
		//this one seems to be required by Xfire?!
		public InvalidRequestMessageFault(String message, InvalidRequestMessageFaultType details){
			super(message);
			this.faultDetail=details;
		}

		public InvalidRequestMessageFault(String message){
			super(message);
		}
		
		public InvalidRequestMessageFaultType getFaultInfo() {
			return faultDetail;
		}
		
		public static QName getFaultName() {
			return InvalidRequestMessageFaultDocument.type.getDocumentElementName();
		}
		
		/**
		/* helper for creating a Fault including the SOAP1.1 element
		*/
		public static InvalidRequestMessageFault createFault(String message){
			InvalidRequestMessageFaultType naf= InvalidRequestMessageFaultType.Factory.newInstance();
			QName faultCode = new QName("bes",InvalidRequestMessageFault.class.getName());
			naf.set(ActivityUtils.buildSOAP11Fault(faultCode, message));
			InvalidRequestMessageFault n=new InvalidRequestMessageFault(message,naf);
			return n;
		}
		

}
