package de.fzj.unicore.bes.client;

import org.codehaus.xfire.fault.XFireFault;
import org.ggf.schemas.bes.x2006.x08.besManagement.StartAcceptingNewActivitiesDocument;
import org.ggf.schemas.bes.x2006.x08.besManagement.StartAcceptingNewActivitiesResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besManagement.StopAcceptingNewActivitiesDocument;
import org.ggf.schemas.bes.x2006.x08.besManagement.StopAcceptingNewActivitiesResponseDocument;

import de.fzj.unicore.bes.BESManagement;
import eu.unicore.security.xfireutil.client.UnicoreXFireClientFactory;
import eu.unicore.util.httpclient.IClientConfiguration;

/**
 * 
 * BESManagement client 
 * 
 * @author m.memon
 *
 */
public class ManagementClient{

	private final BESManagement mgmt;

	private final StartAcceptingNewActivitiesDocument startDoc;
	
	private final StopAcceptingNewActivitiesDocument stopDoc;
	
	public ManagementClient(String url, IClientConfiguration sec)throws Exception{
		mgmt = new UnicoreXFireClientFactory(sec).createPlainWSProxy(BESManagement.class, url);
		startDoc = StartAcceptingNewActivitiesDocument.Factory.newInstance();
		startDoc.addNewStartAcceptingNewActivities();
		stopDoc = StopAcceptingNewActivitiesDocument.Factory.newInstance();
		stopDoc.addNewStopAcceptingNewActivities();
	}
	
	public StartAcceptingNewActivitiesResponseDocument startAcceptingNewActivities() throws XFireFault{
		return mgmt.StartAcceptingNewActivities(startDoc);
	}

	public StopAcceptingNewActivitiesResponseDocument stopAcceptingNewActivities() throws XFireFault{
		return mgmt.StopAcceptingNewActivities(stopDoc);
	}
}
