package de.fzj.unicore.bes.client;

import org.apache.log4j.Logger;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStateEnumeration;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.FactoryResourceAttributesDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentsDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentsResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesResponseType;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesType;
import org.oasisOpen.docs.wsrf.rp2.UpdateResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateResourcePropertiesResponseDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.bes.BESFactory;
import de.fzj.unicore.bes.faults.InvalidRequestMessageFault;
import de.fzj.unicore.bes.faults.NotAcceptingNewActivitiesFault;
import de.fzj.unicore.bes.faults.UnknownActivityIdentifierFault;
import de.fzj.unicore.bes.faults.UnsupportedFeatureFault;
import de.fzj.unicore.bes.util.ActivityUtils;
import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;

/**
 * 
 * TODO: need some code review.
 * 
 * @author m.memon
 */
public class FactoryClient extends BaseUASClient {

    private static final Logger logger = Log.getLogger(Log.CLIENT, ActivityClient.class);
    
    private final BESFactory factory;

    /**
     * @see BaseUASClient#BaseUASClient(String, EndpointReferenceType, IUASSecurityProperties)
     * */
    public FactoryClient(String url, EndpointReferenceType epr,
            IClientConfiguration sec) throws Exception {
        super(url, epr, sec);
        factory = makeProxy(BESFactory.class);
    }

    public FactoryClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        this(epr.getAddress().getStringValue(), epr, sec);
    }

    /**
     * Helper method for create activity operation
     * 
     * @throws NotAcceptingNewActivitiesFault 
     * @throws InvalidRequestMessageFault 
     * 
     */
    public CreateActivityResponseDocument createActivity(
            CreateActivityDocument req) throws NotAcceptingNewActivitiesFault, InvalidRequestMessageFault, UnsupportedFeatureFault {
        if(logger.isDebugEnabled())logger.debug("Calling Service: " + epr.getAddress().getStringValue());
        return factory.CreateActivity(req);
    }

    /**
     * 
     * client wrapper method for fetching a list of given activities' statuses. 
     * 
     * @param req - containing eprs of the activities
     * @return return activity statuses
     * @throws UnknownActivityIdentifierFault 
     */
    public GetActivityStatusesResponseDocument getActivityStatuses(
            GetActivityStatusesDocument req) throws UnknownActivityIdentifierFault {

        GetActivityStatusesResponseDocument res = factory.GetActivityStatuses(req);
        return res;
    }

    /**
     * Client BES method for terminating an array of activities.
     * 
     * @param req
     * @return res  
     * @throws UnknownActivityIdentifierFault 
     */
    public TerminateActivitiesResponseDocument terminateActivities(
            TerminateActivitiesDocument req) throws UnknownActivityIdentifierFault {

        TerminateActivitiesResponseDocument res = factory.TerminateActivities(req);
        return res;
    }

    /**
     * Terminates single activity
     * 
     * @param eprt - epr of the activity
     * @return
     * @throws UnknownActivityIdentifierFault 
     */
    public TerminateActivitiesResponseType terminateActivity(EndpointReferenceType eprt) throws UnknownActivityIdentifierFault {
        TerminateActivitiesDocument tActDoc = TerminateActivitiesDocument.Factory.newInstance();
        TerminateActivitiesType tActType = tActDoc.addNewTerminateActivities();
        tActType.setActivityIdentifierArray(new EndpointReferenceType[]{eprt});
        TerminateActivitiesResponseDocument trmRes = factory.TerminateActivities(tActDoc);
        return trmRes.getTerminateActivitiesResponse();
    }

    /**
     * 
     * Client BES method for getting factory attributes document. 
     * From functionality wise this method is a wrapper call for 
     * GetResourcePropertyDocument. 
     * 
     * @param req - request containing an empty element
     * @return response containing factory resource properties
     */
    public GetFactoryAttributesDocumentResponseDocument getFactoryAttributesDocument(
            GetFactoryAttributesDocumentDocument1 req) throws Exception {
        return factory.GetFactoryAttributesDocument(req);
    }

    public GetFactoryAttributesDocumentResponseDocument getFactoryAttributesDocument() {
        try {
            GetFactoryAttributesDocumentDocument1 req = GetFactoryAttributesDocumentDocument1.Factory.newInstance();
            req.addNewGetFactoryAttributesDocument();
            GetFactoryAttributesDocumentResponseDocument res = factory.GetFactoryAttributesDocument(req);
            return res;
        } catch (BaseFault e) {
            logger.error("Couldn't get the bes factory attributes.", e);
        }
        return null;
    }

    public FactoryResourceAttributesDocumentDocument1 getFactoryResourceAttributes() throws Exception {
        GetFactoryAttributesDocumentDocument1 req = GetFactoryAttributesDocumentDocument1.Factory.newInstance();
        req.addNewGetFactoryAttributesDocument().set(ActivityUtils.filterNoneBeans());
        FactoryResourceAttributesDocumentDocument1 fres = FactoryResourceAttributesDocumentDocument1.Factory.newInstance();
        fres.addNewFactoryResourceAttributesDocument();
        fres.setFactoryResourceAttributesDocument(getFactoryAttributesDocument(req).getGetFactoryAttributesDocumentResponse().getFactoryResourceAttributesDocument());
        return fres;
    }

    /**
     * 
     * This client method retrieves an array of activity documents.
     * @param req - a list of eprs 
     * @return res - a list of corresponding activity documents
     * @throws UnknownActivityIdentifierFault 
     */
    public GetActivityDocumentsResponseDocument getActivityDocuments(
            GetActivityDocumentsDocument req) throws UnknownActivityIdentifierFault {

        GetActivityDocumentsResponseDocument res = factory.GetActivityDocuments(req);
        return res;
    }

    /**
     * Client wrapper method for updating a resource properties document
     * 
     * @param req - contains the qualified name of resource property to be updated
     * @return empty element of UpdateResourcePropertiesDocument
     */
    public UpdateResourcePropertiesResponseDocument updateResourceProperties(UpdateResourcePropertiesDocument req) {

        UpdateResourcePropertiesResponseDocument res = null;
        try {
            res = factory.UpdateResourceProperties(req);
            return res;
        } catch (ResourceUnknownFault e) {
            logger.error("Unable to update resource, resource unknown", e);
        } catch (ResourceUnavailableFault e) {
            logger.error("Unable to update resource, resource unavailable", e);
        } catch (BaseFault e) {
            logger.error("Unable to update resource", e);
        }

        return null;
    }

    public ActivityStateEnumeration.Enum getActivityStatus(EndpointReferenceType eprt) {
        GetActivityStatusesDocument gStatsDoc = GetActivityStatusesDocument.Factory.newInstance();
        GetActivityStatusesType gStatsType = gStatsDoc.addNewGetActivityStatuses();
        gStatsType.setActivityIdentifierArray(new EndpointReferenceType[]{eprt});
        GetActivityStatusesResponseDocument gResDoc = null;
        try {
            gResDoc = factory.GetActivityStatuses(gStatsDoc);
            ActivityStateEnumeration.Enum status = gResDoc.getGetActivityStatusesResponse().getResponseArray()[0].getActivityStatus().getState();
            return status;
        } catch (UnknownActivityIdentifierFault e) {
            logger.error("Couldn't get status.", e);
        }
        return null;
    }

    public String getActivityStatusAsXML(EndpointReferenceType eprt) {
        GetActivityStatusesDocument gStatsDoc = GetActivityStatusesDocument.Factory.newInstance();
        GetActivityStatusesType gStatsType = gStatsDoc.addNewGetActivityStatuses();
        gStatsType.setActivityIdentifierArray(new EndpointReferenceType[]{eprt});
        GetActivityStatusesResponseDocument gResDoc = null;
        try {
            gResDoc = factory.GetActivityStatuses(gStatsDoc);
            return gResDoc.getGetActivityStatusesResponse().getResponseArray()[0].getActivityStatus().toString();
        } catch (UnknownActivityIdentifierFault e) {
            logger.error("Couldn't get status.", e);
        }
        return null;
    }

    public Long getTotalNumberOfActivities() throws Exception {
        long num = getFactoryResourceAttributes().getFactoryResourceAttributesDocument().getTotalNumberOfActivities();
        return num;
    }

    /**
     * wait until an activity is done.
     * 
     * TODO: remove sleep ?
     * 
     * @throws Exception 
     * */
    public String waitWhileActivityIsDone(EndpointReferenceType activityEpr, int timeout) throws Exception {
        ActivityStateEnumeration.Enum status = ActivityStateEnumeration.PENDING;
        long start = System.currentTimeMillis();
        long elapsed = 0;
        while (true) {
            if (timeout > 0 && elapsed > timeout) {
                break;
            }
            elapsed = System.currentTimeMillis() - start;
            status = getActivityStatus(activityEpr);

            if (status == ActivityStateEnumeration.FINISHED) {
                break;
            } else if (status == ActivityStateEnumeration.FAILED) {
                throw new Exception("Job failed");
            }
            Thread.sleep(500);


        }
        return status.toString();
    }

    /**
     * wait until an activity is on ready state.
     * @throws Exception 
     * */
    public String waitWhileActivityIsReady(EndpointReferenceType activityEpr, int timeout) throws Exception {
        ActivityStateEnumeration.Enum status = ActivityStateEnumeration.PENDING;
        long start = System.currentTimeMillis();
        long elapsed = 0;
        while (true) {
            if (timeout > 0 && elapsed > timeout) {
                break;
            }
            elapsed = System.currentTimeMillis() - start;
            status = getActivityStatus(activityEpr);
            if (status.equals(ActivityStateEnumeration.RUNNING)) {
                break;
            }
            if (status.equals(ActivityStateEnumeration.FAILED)
                    || status.equals(ActivityStateEnumeration.FINISHED)) {
                throw new Exception("Job is already done, status is <"
                        + status.toString() + ">");
            }
            Thread.sleep(500);
        }
        return status.toString();
    }
}
