package de.fzj.unicore.bes;

import javax.jws.WebService;

import org.codehaus.xfire.fault.XFireFault;
import org.ggf.schemas.bes.x2006.x08.besManagement.StartAcceptingNewActivitiesDocument;
import org.ggf.schemas.bes.x2006.x08.besManagement.StartAcceptingNewActivitiesResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besManagement.StopAcceptingNewActivitiesDocument;
import org.ggf.schemas.bes.x2006.x08.besManagement.StopAcceptingNewActivitiesResponseDocument;


/**
 * BESManagement port type allows administrative users to stop BES 
 * for further accepting new activities.
 * 
 * @author m.memon
 *
 */
@WebService(targetNamespace="http://schemas.ggf.org/bes/2006/08/bes-management", portName="BESManagementPortType")
public interface BESManagement {

	 
	/**
	 * This operation enables BES to start accepting new activities.
	 * 
	 * @param startRequestDoc
	 * @return
	 * @throws XFireFault
	 */
	@javax.jws.WebMethod(action="http://schemas.ggf.org/bes/2006/08/bes-management/BESManagementPortType/StartAcceptingNewActivities")
	public StartAcceptingNewActivitiesResponseDocument StartAcceptingNewActivities(StartAcceptingNewActivitiesDocument startRequestDoc) throws XFireFault;

	
	/**
	 * This operation is used to request BES stop accepting new activities.
	 * 
	 * @param stopRequestDoc
	 * @return
	 * @throws XFireFault
	 */
	@javax.jws.WebMethod(action="http://schemas.ggf.org/bes/2006/08/bes-management/BESManagementPortType/StopAcceptingNewActivities")
	public StopAcceptingNewActivitiesResponseDocument StopAcceptingNewActivities(StopAcceptingNewActivitiesDocument stopRequestDoc) throws XFireFault;
	
}
