package de.fzj.unicore.bes;


import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.namespace.QName;

import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStatusDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.BasicResourceAttributesDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentsDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentsResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesResponseDocument;
import org.ogf.schemas.glue.x2009.x03.spec20R1.DomainsDocument;

import de.fzj.unicore.bes.faults.InvalidRequestMessageFault;
import de.fzj.unicore.bes.faults.NotAcceptingNewActivitiesFault;
import de.fzj.unicore.bes.faults.UnknownActivityIdentifierFault;
import de.fzj.unicore.bes.faults.UnsupportedFeatureFault;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.WSResource;





/**
 * 
 * BESFactory port type supports BES with operations of creation and manipulation of activities. 
 * The attributes of BESFactory contains the information of the exposed resources, list of activities 
 * and their status information. 
 *  
 *  
 * @author m.memon
 */
@WebService(targetNamespace = "http://schemas.ggf.org/bes/2006/08/bes-factory", portName="BESFactoryPortType")
public interface BESFactory extends WSResource {

	/*
	 * FactoryResourceAttributesDocumentType elements' qualified names  
	 * 
	 */
	// has to be removed
	//public static final QName RPFactoryResourceAttributes = FactoryResourceAttributesDocumentDocument1.type.getDocumentElementName();

	// / Resource Properties ///
	public static final String BES_NS = "http://schemas.ggf.org/bes/2006/08/bes-factory";
										 
	public static final QName RPActivityStatuses = ActivityStatusDocument.type.getDocumentElementName();

	public static final QName RPIsAcceptingNewActivities = new QName(BES_NS, "IsAcceptingNewActivities");

	public static final QName RPNamingProfile = new QName(BES_NS, "NamingProfile");

	public static final QName RPTotalNumberOfActivities = new QName(BES_NS,"TotalNumberOfActivities");
	
	
	// using endpoint type as there is no external element defined of this type in schema
	public static final QName RPActivityReference = new QName(BES_NS, "ActivityReference");

	public static final QName RPCommonName = new QName(BES_NS, "CommonName");
	
	public static final QName RPLongDescription = new QName(BES_NS, "LongDescription");
	
	public static final QName RPTotalNumberOfContainedResources = new QName(BES_NS, "TotalNumberOfContainedResources");

	public static final QName RPLocalResourceManagerType = new QName(BES_NS, "LocalResourceManagerType");

	public static final QName RPBESExtension = new QName(BES_NS, "BESExtension");
	
	public static final QName RPBasicResourceAttributes = BasicResourceAttributesDocumentDocument1.type.getDocumentElementName();
	
	public static final QName RPFilteredActivityReference = new QName(BES_NS, "FilteredActivityReference");
	
	
	// Port Type 
	public static final QName BES_PORT = new QName(BES_NS, "BESFactoryPortType");

	/**
	 * Glue namespace <b>QName</b> of the schemas root element.
	 * */
	public static final QName RPGlueProperties = DomainsDocument.type.getDocumentElementName();
	
	
	public static final QName UnknownActivityIdentifierFaultNS = new QName(BESFactory.BES_NS, "UnknownActivityIdentifierFault");
	public static final QName NotAuthorizedFaultNS = new QName(BESFactory.BES_NS, "NotAuthorizedFault");
	
	
	/**
	 * 
	 * CreateActivity method allows BESFactory the creation of activities. BES creates each activity 
	 * by consuming respective JSDL and submits it to the XNJS (UNICORE's back-end execution system).
	 * If BES's <code>NotAcceptingNewActivities</code> flag is set to false or BESManagement halted BES of accepting new 
	 * activities then it throws NotAcceptingNewActivitiesfault upon the creation of each new activity.
	 * BES throws <code>UnSupportedFeatureFault</code>, if any JSDL element is unknown to BES. 
	 *  BES throws <code>InvalidRequestMessageFault</code> when element in the JSDL is semantically not correct, 
	 * e.g. total number of CPUs in fractional values. 
	 * 
	 * @param req
	 * @return res 
	 * @throws NotAcceptingNewActivitiesFault
	 * @throws InvalidRequestMessageFault
	 * @throws UnsupportedFeatureFault
	 */
	@WebMethod(action = "http://schemas.ggf.org/bes/2006/08/bes-factory/BESFactoryPortType/CreateActivity")
	public CreateActivityResponseDocument CreateActivity(CreateActivityDocument req) throws NotAcceptingNewActivitiesFault, InvalidRequestMessageFault, UnsupportedFeatureFault;

	
	
	/**
	 * 
	 * This operation terminates set of activities by taking activity eprs 
	 * and return the termination status of each activity. If BES unable to terminate any 
	 * activity, due to activity's particular state (Staging-In, Running), the appropriate message
	 * will be appended in the termination response.In case of unknown activities, BES appends 
	 * appropriate SOAP fault.  
	 * 
	 * @param req
	 * @return res
	 * @throws UnknownActivityIdentifierFault
	 */
	@WebMethod(action = "http://schemas.ggf.org/bes/2006/08/bes-factory/BESFactoryPortType/TerminateActivities")
	public TerminateActivitiesResponseDocument TerminateActivities(TerminateActivitiesDocument req) throws UnknownActivityIdentifierFault;

	
	
	
	/**
	 * 
	 * This method returns the status of given set of activities. If any of the activity is not 
	 * identified or client is not authorized to view its status, the returning message will append
	 * the response accordingly. In case of unknown activities, BES appends appropriate SOAP fault.	  
	 * 
	 * @param req
	 * @return res
	 * @throws UnknownActivityIdentifierFault
	 */
	@WebMethod(action = "http://schemas.ggf.org/bes/2006/08/bes-factory/BESFactoryPortType/GetActivityStatuses")
	public GetActivityStatusesResponseDocument GetActivityStatuses(GetActivityStatusesDocument req) throws UnknownActivityIdentifierFault;

	
	
	/**
	 * GetActivityDocuments returns the JSDL documents of the given activity eprs. 
	 * In case of unknown activities, BES appends appropriate SOAP fault.  
	 * 
	 * @param req
	 * @return
	 * @throws UnknownActivityIdentifierFault
	 */
	@WebMethod(action = "http://schemas.ggf.org/bes/2006/08/bes-factory/BESFactoryPortType/GetActivityDocuments")
	public GetActivityDocumentsResponseDocument GetActivityDocuments(GetActivityDocumentsDocument req) throws UnknownActivityIdentifierFault;

	/**
	 * 
	 * GetFactoryAttributesDocument returns all the attributes of BES itself. 
	 * The attributes are categorized as Factory and Basic resource attributes. 
	 * Factory attributes are BES's configuration parameters e.g. is BES accepting new activities. 
	 * Basic Resource attributes exposing the harwdare, software resources which BES owns e.g. OperatingSystemType.  
	 * 
	 * @param req
	 * @return
	 * @throws BaseFault
	 */
	@WebMethod(action = "http://schemas.ggf.org/bes/2006/08/bes-factory/BESFactoryPortType/GetFactoryAttributesDocument")
	public GetFactoryAttributesDocumentResponseDocument GetFactoryAttributesDocument(GetFactoryAttributesDocumentDocument1 req) throws BaseFault;

}
