package de.fzj.unicore.bes;

import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.namespace.QName;

import org.ggf.schemas.bes.x2006.x08.besActivity.ActivityResourceAttributesDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStatusDocument;
import org.unigrids.x2006.x04.services.jms.StartDocument;
import org.unigrids.x2006.x04.services.jms.WorkingDirectoryReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceDocument;

import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.WSResource;





/**
 * BESActivity port type representing web service resource interface to each 
 * of the activities managed by BES. 
 * 
 * @author m.memon, a.memon
 * */
@WebService(targetNamespace = "http://schemas.ggf.org/bes/2006/08/bes-activity/", portName="BESActivityPortType")
public interface BESActivity extends WSResource {
	
	public static final QName RPStatus = ActivityStatusDocument.type.getDocumentElementName();
	public static final QName RPActivityDocument = ActivityDocumentDocument1.type.getDocumentElementName();
	public static final QName RPFactoryReference = EndpointReferenceDocument.type.getDocumentElementName();
	public static final QName RPActivityResourceProperties = ActivityResourceAttributesDocumentDocument1.type.getDocumentElementName();
	
	/**
	 * sms working directory's FQAN
	 * */
	public static final QName RPWorkingDir = WorkingDirectoryReferenceDocument.type.getDocumentElementName();
	
	public static final String ACTIVITY_DOC_KEY = BESActivity.class.getName()+ "_activity.document.key";
	public static final String FACTORY_REF_KEY = BESActivity.class.getName()+ "_bes.factory.reference.key";
	public static final String INIT_ACTION_KEY = BESActivity.class.getName()+ "_bes.xnjs.action.key";
	
	public static final String ACTIVITY_NS = "http://schemas.ggf.org/bes/2006/08/bes-activity";
	
	/**
	 * port type of BESActivity
	 */
	public static final QName ACTIVITY_PORT = new QName(ACTIVITY_NS,"BESActivityPortType");
	
	
	/**
	 * BES methods supporting UNICORE clients. 
	 * */
	@WebMethod(action = "http://schemas.ggf.org/bes/2006/08/bes-activity/BESActivityPortType/StartRequest")
	public org.unigrids.x2006.x04.services.jms.StartResponseDocument Start(StartDocument startDoc)
			throws BaseFault;

	@WebMethod(action = "http://schemas.ggf.org/bes/2006/08/bes-activity/BESActivityPortType/AbortRequest")
	public org.unigrids.x2006.x04.services.jms.AbortResponseDocument Abort(
			org.unigrids.x2006.x04.services.jms.AbortDocument in)
			throws BaseFault;

	@WebMethod(action = "http://schemas.ggf.org/bes/2006/08/bes-activity/BESActivityPortType/HoldRequest")
	public org.unigrids.x2006.x04.services.jms.HoldResponseDocument Hold(
			org.unigrids.x2006.x04.services.jms.HoldDocument in)
			throws BaseFault;
	
	@WebMethod(action = "http://schemas.ggf.org/bes/2006/08/bes-activity/BESActivityPortType/ResumeRequest")
	public org.unigrids.x2006.x04.services.jms.ResumeResponseDocument Resume(
			org.unigrids.x2006.x04.services.jms.ResumeDocument in)
			throws BaseFault;
	
	
	
	
	
	
	
}
