/*********************************************************************************
 * Copyright (c) 2007 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

package de.fzj.unicore.cisprovider.impl;

import java.net.MalformedURLException;
import java.util.Properties;

import de.fzj.unicore.cisprovider.CIPProperties;
import de.fzj.unicore.cisprovider.CISInfoProvider;
import de.fzj.unicore.cisprovider.Monitor;
import de.fzj.unicore.cisprovider.sensors.ApplicationsInfo;
import de.fzj.unicore.cisprovider.sensors.Heartbeat;
import de.fzj.unicore.cisprovider.sensors.JobInfo;
import de.fzj.unicore.cisprovider.sensors.SiteInfo;
import de.fzj.unicore.cisprovider.xmlbeans.GetGlueInfoRequestDocument;
import de.fzj.unicore.cisprovider.xmlbeans.GetInfoRequestDocument;
import de.fzj.unicore.cisprovider.xmlbeans.GetInfoResponseDocument;
import de.fzj.unicore.uas.UASProperties;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.xfire.JettyTestCase;
import de.fzj.unicore.wsrflite.xfire.WSRFClientFactory;
import de.fzj.unicore.wsrflite.xfire.XFireServiceFactory;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

public class TestService extends JettyTestCase {

	protected void setUp()throws Exception{
		super.setUp();
		//configure XNJS
		UASProperties uasP=new UASProperties(new Properties());
		uasP.setProperty(UASProperties.TSF_XNJS_CONFIGFILE, "src/test/resources/xnjs.xml");
		kernel.addConfigurationHandler(UASProperties.class, uasP);
		assertNotNull(XNJSFacade.get(null, kernel).getConfiguration());
		//add sensors
		CIPProperties cipP=new CIPProperties(new Properties());
		cipP.setProperty(CIPProperties.DATA_PATH, "src/test/resources/site-info.json");
		kernel.addConfigurationHandler(CIPProperties.class, cipP);
		Monitor m=kernel.getAttribute(CIPProperties.class).getMonitor();
		m.addSensor(new Heartbeat(kernel));
		m.addSensor(new SiteInfo(kernel));
		m.addSensor(new ApplicationsInfo(kernel));
		m.addSensor(new JobInfo(kernel));
	}
	
	@Override
	protected void addServices() throws Exception {
		XFireServiceFactory.createAndDeployService(kernel, "mon",CISInfoProvider.class, CISInfoProviderImpl.class, false);
	}

	public void testGetInfo(){
		try{
			String url=getBaseurl()+"/mon";
			System.out.println(url);
			CISInfoProvider ip=new WSRFClientFactory().createPlainWSProxy(CISInfoProvider.class, url);
			GetInfoRequestDocument req=GetInfoRequestDocument.Factory.newInstance();
			req.addNewGetInfoRequest();
			req.getGetInfoRequest().setTopic("/Site");
			System.out.println(ip.getInfo(req));
			Thread.sleep(2000);
			System.out.println(ip.getInfo(req));
			//check for the General info --- must have a single entry here
			req=GetInfoRequestDocument.Factory.newInstance();
			req.addNewGetInfoRequest();
			req.getGetInfoRequest().setTopic("/Site/General");
			GetInfoResponseDocument res=ip.getInfo(req);
			assertEquals(1,res.getGetInfoResponse().getFeed().getEntryArray().length);
			
		}catch(Exception e){
			e.printStackTrace();
			fail();
		}
	}
	
	public void testGetGlueInfo(){
		try {
			String url=getBaseurl()+"/mon";
			CISInfoProvider ip=new WSRFClientFactory().createPlainWSProxy(CISInfoProvider.class, url);
			GetGlueInfoRequestDocument req = GetGlueInfoRequestDocument.Factory.newInstance();
			req.addNewGetGlueInfoRequest();
			String res=ip.getGlueInfo(req).toString();
			System.out.println(res);
			assertTrue(res.contains("glue"));				
		} catch (MalformedURLException e) {
			fail();
		} catch (BaseFault e) {
			fail();
		} 
	}
}
