package de.fzj.unicore.cisprovider.impl;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

import org.apache.commons.io.FileUtils;
import org.apache.xmlbeans.XmlOptions;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.CPUArchitectureType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ProcessorArchitectureEnumeration;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;
import org.ogf.schemas.glue.x2009.x03.spec20R1.DomainsDocument;

import de.fzj.unicore.cisprovider.MonitoringEvent;
import de.fzj.unicore.cisprovider.Topics;
import de.fzj.unicore.cisprovider.xmlbeans.JobsDocument;
import de.fzj.unicore.cisprovider.xmlbeans.SiteDocument;

public class TestGlueInfoGenerator extends TestCase {
	
	private static DomainsDocument dDoc;

	public void testGenerateGlueInstance() {
		generateGlue();
	}

	/** Testing if the generated Glue2 document is valid */
	public void testValidateGlueInstance() {
		generateGlue();
		XmlOptions opts = new XmlOptions();
		List<String> validationErrors = new ArrayList<String>();
		opts.setErrorListener(validationErrors);
		
		dDoc.validate(opts);
		int numErrors = validationErrors.size();
		
		if (numErrors > 0) {
			System.out
					.println("There were "
							+ numErrors
							+ " Glue2 validation error(s)");
			for (int i = 0; i < numErrors; i++) {
				System.out.println(String.valueOf(validationErrors.get(i)));
			}
			
		}
		
		assertTrue(numErrors==0);
	}
	
	private void generateGlue(){

		String cipDataPath="src/test/resources/site-info.json";
		
		List<MonitoringEvent> events = new ArrayList<MonitoringEvent>();
		DefaultMonitoringEvent site = new DefaultMonitoringEvent();
		site.setDescription("This contains general information about the site");
		site.setTopic(Topics.SITE + "/General");
		site.setTitle("Site information");
		SiteDocument sd = SiteDocument.Factory.newInstance();
		sd.addNewSite().addNewGeoData().setLatitude("50");
		sd.getSite().getGeoData().setLongitude("3");
		sd.getSite().setName("Test Site at Localhost");
		site.setDetails(sd);
		
		events.add(site);

		DefaultMonitoringEvent jobs = new DefaultMonitoringEvent();
		jobs.setDescription("This contains information about the jobs on the site");
		jobs.setTopic(Topics.JOBS + "/General");
		jobs.setTitle("Job information");
		JobsDocument jd = JobsDocument.Factory.newInstance();
		jd.addNewJobs().setTotalJobs(BigInteger.valueOf(1000));
		jd.addNewJobs().setFinishedJobs(BigInteger.valueOf(123));
		jd.getJobs().setRunningJobs(BigInteger.valueOf(456));
		jobs.setDetails(jd);
		events.add(jobs);

		DefaultMonitoringEvent apps = new DefaultMonitoringEvent();
		apps.setDescription("This contains Applications installed at computing site");
		apps.setTopic(Topics.APPLICATIONS + "/General");
		apps.setTitle("Applications information");
		ApplicationType a1 = ApplicationType.Factory.newInstance();
		a1.setApplicationName("test");
		a1.setApplicationVersion("1");
		ApplicationType[] appT = new ApplicationType[] { a1 };
		apps.setDetailsArray(appT);
		events.add(apps);
		
		DefaultMonitoringEvent exEnv = new DefaultMonitoringEvent();
		apps.setDescription("This contains Execution Environment available at the computing site");
		apps.setTopic(Topics.EXECUTION + "/General");
		apps.setTitle("Execution Environment information");
		ResourcesDocument rd = ResourcesDocument.Factory.newInstance();
		ResourcesType rt = rd.addNewResources();
		CPUArchitectureType ct = CPUArchitectureType.Factory.newInstance();
		ct.setCPUArchitectureName(ProcessorArchitectureEnumeration.X_86_64);
		rt.setCPUArchitecture(ct);		
		apps.setDetails(rd);
		events.add(exEnv);
		
		try {
			File vFile=new File("target","versionFile-"+System.currentTimeMillis());
			String b="1.2.3-1";
			String unique="foo";
			FileUtils.write(vFile, b);
			GlueInstanceGenerator g=new GlueInstanceGenerator();
			g.setVersionFile(vFile.getPath());
			DomainsDocument dd = g.generate(events,cipDataPath,unique);
			dDoc = dd;
			assertNotNull(dd);
			String v=dd.getDomains().getAdminDomainArray(0).getComputingServiceArray(0).getComputingEndpointArray(0).getOtherInfoArray(1);
			assertEquals("MiddlewareVersion="+b,v);
			System.out.println(dd);
		} catch (Exception ex) {
			ex.printStackTrace();
			fail();
		}
	}
	
}
