package de.fzj.unicore.cisprovider.impl;

import org.ogf.schemas.glue.x2009.x03.spec20R1.ServiceT;

import de.fzj.unicore.cisprovider.CISInfoProvider;
import de.fzj.unicore.cisprovider.xmlbeans.GetServiceInfoRequestDocument;
import de.fzj.unicore.cisprovider.xmlbeans.GetServiceInfoResponseDocument;
import de.fzj.unicore.wsrflite.xfire.JettyTestCase;
import de.fzj.unicore.wsrflite.xfire.XFireServiceFactory;
import de.fzj.unicore.wsrflite.xmlbeans.registry.LocalRegistryEntryHomeImpl;
import de.fzj.unicore.wsrflite.xmlbeans.registry.LocalRegistryHomeImpl;
import de.fzj.unicore.wsrflite.xmlbeans.sg.Registry;
import de.fzj.unicore.wsrflite.xmlbeans.sg.ServiceGroupEntry;

public class TestGetServiceInfo extends JettyTestCase {
	@Override
	protected void addServices() throws Exception {
		XFireServiceFactory.createAndDeployService(kernel,Registry.REGISTRY_SERVICE, Registry.class,
				LocalRegistryHomeImpl.class, true);
		XFireServiceFactory.createAndDeployService(kernel,ServiceGroupEntry.SERVICENAME, Registry.class,
				LocalRegistryEntryHomeImpl.class, true);
		XFireServiceFactory.createAndDeployService(kernel,CISInfoProvider.SERVICENAME, CISInfoProvider.class,
				CISInfoProviderImpl.class, false);

	}

	public void testGetServiceInfo() throws Exception {
		CISInfoProviderImpl cip = new CISInfoProviderImpl();
		cip.setKernel(kernel);
		GetServiceInfoRequestDocument req = GetServiceInfoRequestDocument.Factory
				.newInstance();
		req.addNewGetServiceInfoRequest();
		GetServiceInfoResponseDocument res = cip.getServiceInfo(req);
		ServiceT[] s = res.getGetServiceInfoResponse().getServiceArray();
		assertTrue(s.length > 0);
		assertEquals(s[0].getName(), CISInfoProvider.SERVICENAME);
		System.out.println(res);
	}


}
