/*********************************************************************************
 * Copyright (c) 2007 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

package de.fzj.unicore.cisprovider.impl;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

import junit.framework.TestCase;

import org.apache.xmlbeans.XmlString;
import org.oasisOpen.docs.wsn.b2.TerminationTimeDocument;
import org.w3.x2005.atom.FeedDocument;

import de.fzj.unicore.cisprovider.MonitoringEvent;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.TestConfigUtil;

public class TestFeedGenerator extends TestCase{

	public void test1() throws Exception{
		DefaultMonitoringEvent e1=new DefaultMonitoringEvent();
		DefaultMonitoringEvent e2=new DefaultMonitoringEvent();
		e1.setDescription("A sample event");
		e1.setTopic("topic");
		e2.setDescription("A second sample event");
		e1.setTopic("topic/subtopic");
		XmlString content=XmlString.Factory.newInstance();
		content.setStringValue("sample content");
		e2.setDetails(content);
		DefaultMonitoringEvent e3=new DefaultMonitoringEvent();
		e3.setDescription("A complex sample event");
		e3.setTopic("topic3");
		TerminationTimeDocument content3=TerminationTimeDocument.Factory.newInstance();
		content3.setTerminationTime(Calendar.getInstance());
		e3.setDetails(content3);
		Kernel k=new Kernel(TestConfigUtil.getInsecureProperties());
		List<MonitoringEvent>list=Arrays.asList(new MonitoringEvent[]{e1,e2,e3});
		FeedDocument feed=FeedGenerator.generateFeed(list,k);
		String f=feed.toString();
		System.out.println(f);
		assertTrue(f.contains("A sample event"));
		assertTrue(f.contains("sample content"));
		assertTrue(f.contains("A second sample event"));
		assertTrue(f.contains("TerminationTime"));
	}
	
}
