/*********************************************************************************
 * Copyright (c) 2007 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

package de.fzj.unicore.cisprovider.beans;

import java.math.BigInteger;
import java.util.Calendar;

import junit.framework.TestCase;

import org.apache.xmlbeans.XmlString;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingServiceT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.DomainsDocument;
import org.w3.x2005.atom.EntryType;
import org.w3.x2005.atom.FeedType;

import de.fzj.unicore.cisprovider.xmlbeans.GetInfoRequestDocument;
import de.fzj.unicore.cisprovider.xmlbeans.GetInfoResponseDocument;

public class TestBeans extends TestCase{

	public void test1(){
		GetInfoRequestDocument r=GetInfoRequestDocument.Factory.newInstance();
		r.addNewGetInfoRequest().setMaxNumberOfRecords(BigInteger.valueOf(100));
		r.getGetInfoRequest().setTopic("/");
		System.out.println(r);
		GetInfoResponseDocument res=GetInfoResponseDocument.Factory.newInstance();
		FeedType f=FeedType.Factory.newInstance();
		f.addNewAuthor().addName("Stephen King");
		f.getAuthorArray()[0].addEmail("s.king@boringbooks.com");
		res.addNewGetInfoResponse().setFeed(f);
		System.out.println(res);
	}
	
	public void test2(){
		EntryType e=EntryType.Factory.newInstance();
		e.addNewPublished().setCalendarValue(Calendar.getInstance());
		XmlString s=XmlString.Factory.newInstance();
		s.setStringValue("A sample entry");
		e.addNewSummary().set(s);
		System.out.println(e);
	}
	
	public void test3(){
		DomainsDocument dd=DomainsDocument.Factory.newInstance();
		System.out.println(dd);
		ComputingServiceT cs=ComputingServiceT.Factory.newInstance();
		cs.addNewContact().setID("test");
		System.out.println(cs);
		
	}
	
}
