package de.fzj.unicore.cisprovider.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

import de.fzj.unicore.uas.util.LogUtil;
/** 
 * Utility class to handle date/calendar objects
 *  */
public class DateUtil {
	public static Calendar toCalendar(String strDate) {
		return toCalendar(strDate, "dd.mm.yyyy");
	}
	
	public static Calendar toCalendar(String strDate, String strFormat) {
		DateFormat formatter;
		Date date = null;
		formatter = new SimpleDateFormat(strFormat);
		try {
			date = (Date) formatter.parse(strDate);
		} catch (ParseException e) {
			LogUtil.logException("Failed to parse string date", e);
		}
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		strictUTC(cal);
		return cal;
	}
	
	/**
	 * ensures strict UTC output, without fractional seconds, and without timezone info<br/>
	 * e.g. "2012-11-13T12:46:32Z"
	 * 
	 * @param cal
	 * @return the same calendar instance with UTC timezone set
	 */
	public static Calendar strictUTC(Calendar cal){
		cal.setTimeZone(TimeZone.getTimeZone("UTC"));
		cal.clear(Calendar.MILLISECOND);
		return cal;
	}
	
}
