package de.fzj.unicore.cisprovider.sensors;

import org.unigrids.services.atomic.types.TextInfoType;

import de.fzj.unicore.cisprovider.Topics;
import de.fzj.unicore.cisprovider.impl.DefaultMonitoringEvent;
import de.fzj.unicore.cisprovider.impl.DefaultSensor;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
/** Sensor for site specific administrator defined information events */
public class TextInfo extends DefaultSensor{

	@Override
	public String getName() {
		return "TextInfo";
	}
	public TextInfo(Kernel kernel) {
		super(kernel);
		setLastEvent(createEvent());
	}
	protected DefaultMonitoringEvent createEvent(){
		DefaultMonitoringEvent e=new DefaultMonitoringEvent();
		e.setDescription("This contains additional administrator defined attributes pertinent to specfic UNICORE Site");
		e.setTopic(Topics.TEXT+"/General");
		e.setTitle("Additional information");
		e.setDetailsArray(makeDetailedSiteInfo());
		if(getLastEvent()!=null)e.setSupersedes(getLastEvent().getID());
		return e;
	}
	private TextInfoType[] makeDetailedSiteInfo() {
		TextInfoType[] txtType = XNJSFacade.get(null,kernel).getDefinedTextInfo();
		return txtType;
	}
	

}
